// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



public class ImportCertificateRequest private constructor(builder: Builder) {
    /**
     * The certificate to import.
     */
    public val certificate: kotlin.ByteArray? = builder.certificate
    /**
     * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of an imported certificate to replace. To import a new certificate, omit this field.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The PEM encoded certificate chain.
     */
    public val certificateChain: kotlin.ByteArray? = builder.certificateChain
    /**
     * The private key that matches the public key in the certificate.
     */
    public val privateKey: kotlin.ByteArray? = builder.privateKey
    /**
     * One or more resource tags to associate with the imported certificate.
     *
     * Note: You cannot apply tags when reimporting a certificate.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.ImportCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportCertificateRequest(")
        append("certificate=$certificate,")
        append("certificateArn=$certificateArn,")
        append("certificateChain=$certificateChain,")
        append("privateKey=*** Sensitive Data Redacted ***,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.contentHashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (certificateChain?.contentHashCode() ?: 0)
        result = 31 * result + (privateKey?.contentHashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportCertificateRequest

        if (certificate != null) {
            if (other.certificate == null) return false
            if (!certificate.contentEquals(other.certificate)) return false
        } else if (other.certificate != null) return false
        if (certificateArn != other.certificateArn) return false
        if (certificateChain != null) {
            if (other.certificateChain == null) return false
            if (!certificateChain.contentEquals(other.certificateChain)) return false
        } else if (other.certificateChain != null) return false
        if (privateKey != null) {
            if (other.privateKey == null) return false
            if (!privateKey.contentEquals(other.privateKey)) return false
        } else if (other.privateKey != null) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.ImportCertificateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The certificate to import.
         */
        public var certificate: kotlin.ByteArray? = null
        /**
         * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of an imported certificate to replace. To import a new certificate, omit this field.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The PEM encoded certificate chain.
         */
        public var certificateChain: kotlin.ByteArray? = null
        /**
         * The private key that matches the public key in the certificate.
         */
        public var privateKey: kotlin.ByteArray? = null
        /**
         * One or more resource tags to associate with the imported certificate.
         *
         * Note: You cannot apply tags when reimporting a certificate.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.ImportCertificateRequest) : this() {
            this.certificate = x.certificate
            this.certificateArn = x.certificateArn
            this.certificateChain = x.certificateChain
            this.privateKey = x.privateKey
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.ImportCertificateRequest = ImportCertificateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
