// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate. This structure exists only when the certificate type is `AMAZON_ISSUED`.
 */
public class RenewalSummary private constructor(builder: Builder) {
    /**
     * Contains information about the validation of each domain name in the certificate, as it pertains to ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html). This is different from the initial validation that occurs as a result of the RequestCertificate request. This field exists only when the certificate type is `AMAZON_ISSUED`.
     */
    public val domainValidationOptions: List<DomainValidation>? = builder.domainValidationOptions
    /**
     * The status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) of the certificate.
     */
    public val renewalStatus: aws.sdk.kotlin.services.acm.model.RenewalStatus? = builder.renewalStatus
    /**
     * The reason that a renewal request was unsuccessful.
     */
    public val renewalStatusReason: aws.sdk.kotlin.services.acm.model.FailureReason? = builder.renewalStatusReason
    /**
     * The time at which the renewal summary was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.RenewalSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RenewalSummary(")
        append("domainValidationOptions=$domainValidationOptions,")
        append("renewalStatus=$renewalStatus,")
        append("renewalStatusReason=$renewalStatusReason,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainValidationOptions?.hashCode() ?: 0
        result = 31 * result + (renewalStatus?.hashCode() ?: 0)
        result = 31 * result + (renewalStatusReason?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RenewalSummary

        if (domainValidationOptions != other.domainValidationOptions) return false
        if (renewalStatus != other.renewalStatus) return false
        if (renewalStatusReason != other.renewalStatusReason) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.RenewalSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains information about the validation of each domain name in the certificate, as it pertains to ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html). This is different from the initial validation that occurs as a result of the RequestCertificate request. This field exists only when the certificate type is `AMAZON_ISSUED`.
         */
        public var domainValidationOptions: List<DomainValidation>? = null
        /**
         * The status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) of the certificate.
         */
        public var renewalStatus: aws.sdk.kotlin.services.acm.model.RenewalStatus? = null
        /**
         * The reason that a renewal request was unsuccessful.
         */
        public var renewalStatusReason: aws.sdk.kotlin.services.acm.model.FailureReason? = null
        /**
         * The time at which the renewal summary was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.RenewalSummary) : this() {
            this.domainValidationOptions = x.domainValidationOptions
            this.renewalStatus = x.renewalStatus
            this.renewalStatusReason = x.renewalStatusReason
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.RenewalSummary = RenewalSummary(this)
    }
}
