// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



class ValidatePolicyRequest private constructor(builder: BuilderImpl) {
    /**
     * The locale to use for localizing the findings.
     */
    val locale: Locale? = builder.locale
    /**
     * The maximum number of results to return in the response.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The JSON policy document to use as the content for the policy.
     */
    val policyDocument: String? = builder.policyDocument
    /**
     * The type of policy to validate. Identity policies grant permissions to IAM principals.
     * Identity policies include managed and inline policies for IAM roles, users, and groups.
     * They also include service-control policies (SCPs) that are attached to an Amazon Web Services
     * organization, organizational unit (OU), or an account.
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
     * policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic
     * input such as identity policy or resource policy or a specific input such as managed policy
     * or Amazon S3 bucket policy.
     */
    val policyType: PolicyType? = builder.policyType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ValidatePolicyRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ValidatePolicyRequest(")
        append("locale=$locale,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("policyDocument=$policyDocument,")
        append("policyType=$policyType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = locale?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ValidatePolicyRequest

        if (locale != other.locale) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (policyDocument != other.policyDocument) return false
        if (policyType != other.policyType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ValidatePolicyRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ValidatePolicyRequest
        /**
         * The locale to use for localizing the findings.
         */
        fun locale(locale: Locale): FluentBuilder
        /**
         * The maximum number of results to return in the response.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token used for pagination of results returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The JSON policy document to use as the content for the policy.
         */
        fun policyDocument(policyDocument: String): FluentBuilder
        /**
         * The type of policy to validate. Identity policies grant permissions to IAM principals.
         * Identity policies include managed and inline policies for IAM roles, users, and groups.
         * They also include service-control policies (SCPs) that are attached to an Amazon Web Services
         * organization, organizational unit (OU), or an account.
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic
         * input such as identity policy or resource policy or a specific input such as managed policy
         * or Amazon S3 bucket policy.
         */
        fun policyType(policyType: PolicyType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The locale to use for localizing the findings.
         */
        var locale: Locale?
        /**
         * The maximum number of results to return in the response.
         */
        var maxResults: Int?
        /**
         * A token used for pagination of results returned.
         */
        var nextToken: String?
        /**
         * The JSON policy document to use as the content for the policy.
         */
        var policyDocument: String?
        /**
         * The type of policy to validate. Identity policies grant permissions to IAM principals.
         * Identity policies include managed and inline policies for IAM roles, users, and groups.
         * They also include service-control policies (SCPs) that are attached to an Amazon Web Services
         * organization, organizational unit (OU), or an account.
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic
         * input such as identity policy or resource policy or a specific input such as managed policy
         * or Amazon S3 bucket policy.
         */
        var policyType: PolicyType?

        fun build(): ValidatePolicyRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var locale: Locale? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var policyDocument: String? = null
        override var policyType: PolicyType? = null

        constructor(x: ValidatePolicyRequest) : this() {
            this.locale = x.locale
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.policyDocument = x.policyDocument
            this.policyType = x.policyType
        }

        override fun build(): ValidatePolicyRequest = ValidatePolicyRequest(this)
        override fun locale(locale: Locale): FluentBuilder = apply { this.locale = locale }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun policyDocument(policyDocument: String): FluentBuilder = apply { this.policyDocument = policyDocument }
        override fun policyType(policyType: PolicyType): FluentBuilder = apply { this.policyType = policyType }
    }
}
