// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * A finding in a policy. Each finding is an actionable recommendation that can be used to
 * improve the policy.
 */
class ValidatePolicyFinding private constructor(builder: BuilderImpl) {
    /**
     * A localized message that explains the finding and provides guidance on how to address
     * it.
     */
    val findingDetails: String? = builder.findingDetails
    /**
     * The impact of the finding.
     * Security warnings report when the policy allows access that we consider overly
     * permissive.
     * Errors report when a part of the policy is not functional.
     * Warnings report non-security issues when a policy does not conform to policy writing
     * best practices.
     * Suggestions recommend stylistic improvements in the policy that do not impact
     * access.
     */
    val findingType: ValidatePolicyFindingType? = builder.findingType
    /**
     * The issue code provides an identifier of the issue associated with this finding.
     */
    val issueCode: String? = builder.issueCode
    /**
     * A link to additional documentation about the type of finding.
     */
    val learnMoreLink: String? = builder.learnMoreLink
    /**
     * The list of locations in the policy document that are related to the finding. The issue
     * code provides a summary of an issue identified by the finding.
     */
    val locations: List<Location>? = builder.locations

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ValidatePolicyFinding = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ValidatePolicyFinding(")
        append("findingDetails=$findingDetails,")
        append("findingType=$findingType,")
        append("issueCode=$issueCode,")
        append("learnMoreLink=$learnMoreLink,")
        append("locations=$locations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = findingDetails?.hashCode() ?: 0
        result = 31 * result + (findingType?.hashCode() ?: 0)
        result = 31 * result + (issueCode?.hashCode() ?: 0)
        result = 31 * result + (learnMoreLink?.hashCode() ?: 0)
        result = 31 * result + (locations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ValidatePolicyFinding

        if (findingDetails != other.findingDetails) return false
        if (findingType != other.findingType) return false
        if (issueCode != other.issueCode) return false
        if (learnMoreLink != other.learnMoreLink) return false
        if (locations != other.locations) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ValidatePolicyFinding = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ValidatePolicyFinding
        /**
         * A localized message that explains the finding and provides guidance on how to address
         * it.
         */
        fun findingDetails(findingDetails: String): FluentBuilder
        /**
         * The impact of the finding.
         * Security warnings report when the policy allows access that we consider overly
         * permissive.
         * Errors report when a part of the policy is not functional.
         * Warnings report non-security issues when a policy does not conform to policy writing
         * best practices.
         * Suggestions recommend stylistic improvements in the policy that do not impact
         * access.
         */
        fun findingType(findingType: ValidatePolicyFindingType): FluentBuilder
        /**
         * The issue code provides an identifier of the issue associated with this finding.
         */
        fun issueCode(issueCode: String): FluentBuilder
        /**
         * A link to additional documentation about the type of finding.
         */
        fun learnMoreLink(learnMoreLink: String): FluentBuilder
        /**
         * The list of locations in the policy document that are related to the finding. The issue
         * code provides a summary of an issue identified by the finding.
         */
        fun locations(locations: List<Location>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A localized message that explains the finding and provides guidance on how to address
         * it.
         */
        var findingDetails: String?
        /**
         * The impact of the finding.
         * Security warnings report when the policy allows access that we consider overly
         * permissive.
         * Errors report when a part of the policy is not functional.
         * Warnings report non-security issues when a policy does not conform to policy writing
         * best practices.
         * Suggestions recommend stylistic improvements in the policy that do not impact
         * access.
         */
        var findingType: ValidatePolicyFindingType?
        /**
         * The issue code provides an identifier of the issue associated with this finding.
         */
        var issueCode: String?
        /**
         * A link to additional documentation about the type of finding.
         */
        var learnMoreLink: String?
        /**
         * The list of locations in the policy document that are related to the finding. The issue
         * code provides a summary of an issue identified by the finding.
         */
        var locations: List<Location>?

        fun build(): ValidatePolicyFinding
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var findingDetails: String? = null
        override var findingType: ValidatePolicyFindingType? = null
        override var issueCode: String? = null
        override var learnMoreLink: String? = null
        override var locations: List<Location>? = null

        constructor(x: ValidatePolicyFinding) : this() {
            this.findingDetails = x.findingDetails
            this.findingType = x.findingType
            this.issueCode = x.issueCode
            this.learnMoreLink = x.learnMoreLink
            this.locations = x.locations
        }

        override fun build(): ValidatePolicyFinding = ValidatePolicyFinding(this)
        override fun findingDetails(findingDetails: String): FluentBuilder = apply { this.findingDetails = findingDetails }
        override fun findingType(findingType: ValidatePolicyFindingType): FluentBuilder = apply { this.findingType = findingType }
        override fun issueCode(issueCode: String): FluentBuilder = apply { this.issueCode = issueCode }
        override fun learnMoreLink(learnMoreLink: String): FluentBuilder = apply { this.learnMoreLink = learnMoreLink }
        override fun locations(locations: List<Location>): FluentBuilder = apply { this.locations = locations }
    }
}
