// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Updates findings with the new values provided in the request.
 */
class UpdateFindingsRequest private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
     * the analyzer that generated the findings to update.
     */
    val analyzerArn: String? = builder.analyzerArn
    /**
     * A client token.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The IDs of the findings to update.
     */
    val ids: List<String>? = builder.ids
    /**
     * The ARN of the resource identified in the finding.
     */
    val resourceArn: String? = builder.resourceArn
    /**
     * The state represents the action to take to update the finding Status. Use
     * ARCHIVE to change an Active finding to an Archived finding. Use
     * ACTIVE to change an Archived finding to an Active finding.
     */
    val status: FindingStatusUpdate? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateFindingsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFindingsRequest(")
        append("analyzerArn=$analyzerArn,")
        append("clientToken=$clientToken,")
        append("ids=$ids,")
        append("resourceArn=$resourceArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (ids?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateFindingsRequest

        if (analyzerArn != other.analyzerArn) return false
        if (clientToken != other.clientToken) return false
        if (ids != other.ids) return false
        if (resourceArn != other.resourceArn) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateFindingsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateFindingsRequest
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer that generated the findings to update.
         */
        fun analyzerArn(analyzerArn: String): FluentBuilder
        /**
         * A client token.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The IDs of the findings to update.
         */
        fun ids(ids: List<String>): FluentBuilder
        /**
         * The ARN of the resource identified in the finding.
         */
        fun resourceArn(resourceArn: String): FluentBuilder
        /**
         * The state represents the action to take to update the finding Status. Use
         * ARCHIVE to change an Active finding to an Archived finding. Use
         * ACTIVE to change an Archived finding to an Active finding.
         */
        fun status(status: FindingStatusUpdate): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer that generated the findings to update.
         */
        var analyzerArn: String?
        /**
         * A client token.
         */
        var clientToken: String?
        /**
         * The IDs of the findings to update.
         */
        var ids: List<String>?
        /**
         * The ARN of the resource identified in the finding.
         */
        var resourceArn: String?
        /**
         * The state represents the action to take to update the finding Status. Use
         * ARCHIVE to change an Active finding to an Archived finding. Use
         * ACTIVE to change an Archived finding to an Active finding.
         */
        var status: FindingStatusUpdate?

        fun build(): UpdateFindingsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerArn: String? = null
        override var clientToken: String? = null
        override var ids: List<String>? = null
        override var resourceArn: String? = null
        override var status: FindingStatusUpdate? = null

        constructor(x: UpdateFindingsRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.clientToken = x.clientToken
            this.ids = x.ids
            this.resourceArn = x.resourceArn
            this.status = x.status
        }

        override fun build(): UpdateFindingsRequest = UpdateFindingsRequest(this)
        override fun analyzerArn(analyzerArn: String): FluentBuilder = apply { this.analyzerArn = analyzerArn }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun ids(ids: List<String>): FluentBuilder = apply { this.ids = ids }
        override fun resourceArn(resourceArn: String): FluentBuilder = apply { this.resourceArn = resourceArn }
        override fun status(status: FindingStatusUpdate): FluentBuilder = apply { this.status = status }
    }
}
