// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Updates the specified archive rule.
 */
class UpdateArchiveRuleRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the analyzer to update the archive rules for.
     */
    val analyzerName: String? = builder.analyzerName
    /**
     * A client token.
     */
    val clientToken: String? = builder.clientToken
    /**
     * A filter to match for the rules to update. Only rules that match the filter are
     * updated.
     */
    val filter: Map<String, Criterion>? = builder.filter
    /**
     * The name of the rule to update.
     */
    val ruleName: String? = builder.ruleName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateArchiveRuleRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateArchiveRuleRequest(")
        append("analyzerName=$analyzerName,")
        append("clientToken=$clientToken,")
        append("filter=$filter,")
        append("ruleName=$ruleName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerName?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateArchiveRuleRequest

        if (analyzerName != other.analyzerName) return false
        if (clientToken != other.clientToken) return false
        if (filter != other.filter) return false
        if (ruleName != other.ruleName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateArchiveRuleRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateArchiveRuleRequest
        /**
         * The name of the analyzer to update the archive rules for.
         */
        fun analyzerName(analyzerName: String): FluentBuilder
        /**
         * A client token.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * A filter to match for the rules to update. Only rules that match the filter are
         * updated.
         */
        fun filter(filter: Map<String, Criterion>): FluentBuilder
        /**
         * The name of the rule to update.
         */
        fun ruleName(ruleName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the analyzer to update the archive rules for.
         */
        var analyzerName: String?
        /**
         * A client token.
         */
        var clientToken: String?
        /**
         * A filter to match for the rules to update. Only rules that match the filter are
         * updated.
         */
        var filter: Map<String, Criterion>?
        /**
         * The name of the rule to update.
         */
        var ruleName: String?

        fun build(): UpdateArchiveRuleRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerName: String? = null
        override var clientToken: String? = null
        override var filter: Map<String, Criterion>? = null
        override var ruleName: String? = null

        constructor(x: UpdateArchiveRuleRequest) : this() {
            this.analyzerName = x.analyzerName
            this.clientToken = x.clientToken
            this.filter = x.filter
            this.ruleName = x.ruleName
        }

        override fun build(): UpdateArchiveRuleRequest = UpdateArchiveRuleRequest(this)
        override fun analyzerName(analyzerName: String): FluentBuilder = apply { this.analyzerName = analyzerName }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun filter(filter: Map<String, Criterion>): FluentBuilder = apply { this.filter = filter }
        override fun ruleName(ruleName: String): FluentBuilder = apply { this.ruleName = ruleName }
    }
}
