// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The proposed access control configuration for an Amazon SQS queue. You can propose a
 * configuration for a new Amazon SQS queue or an existing Amazon SQS queue that you own by specifying
 * the Amazon SQS policy. If the configuration is for an existing Amazon SQS queue and you do not
 * specify the Amazon SQS policy, the access preview uses the existing Amazon SQS policy for the queue.
 * If the access preview is for a new resource and you do not specify the policy, the access
 * preview assumes an Amazon SQS queue without a policy. To propose deletion of an existing Amazon SQS
 * queue policy, you can specify an empty string for the Amazon SQS policy. For more information
 * about Amazon SQS policy limits, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html">Quotas related
 * to policies.
 */
class SqsQueueConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The proposed resource policy for the Amazon SQS queue.
     */
    val queuePolicy: String? = builder.queuePolicy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SqsQueueConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SqsQueueConfiguration(")
        append("queuePolicy=$queuePolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = queuePolicy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SqsQueueConfiguration

        if (queuePolicy != other.queuePolicy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SqsQueueConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SqsQueueConfiguration
        /**
         * The proposed resource policy for the Amazon SQS queue.
         */
        fun queuePolicy(queuePolicy: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The proposed resource policy for the Amazon SQS queue.
         */
        var queuePolicy: String?

        fun build(): SqsQueueConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var queuePolicy: String? = null

        constructor(x: SqsQueueConfiguration) : this() {
            this.queuePolicy = x.queuePolicy
        }

        override fun build(): SqsQueueConfiguration = SqsQueueConfiguration(this)
        override fun queuePolicy(queuePolicy: String): FluentBuilder = apply { this.queuePolicy = queuePolicy }
    }
}
