// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The configuration for a Secrets Manager secret. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html">CreateSecret.
 * You can propose a configuration for a new secret or an existing secret that you own by
 * specifying the secret policy and optional KMS encryption key. If the configuration is for
 * an existing secret and you do not specify the secret policy, the access preview uses the
 * existing policy for the secret. If the access preview is for a new resource and you do not
 * specify the policy, the access preview assumes a secret without a policy. To propose
 * deletion of an existing policy, you can specify an empty string. If the proposed
 * configuration is for a new secret and you do not specify the KMS key ID, the access
 * preview uses the default CMK of the Amazon Web Services account. If you specify an empty string for the
 * KMS key ID, the access preview uses the default CMK of the Amazon Web Services account. For more
 * information about secret policy limits, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html">Quotas for
 * Secrets Manager..
 */
class SecretsManagerSecretConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The proposed ARN, key ID, or alias of the KMS customer master key (CMK).
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The proposed resource policy defining who can access or manage the secret.
     */
    val secretPolicy: String? = builder.secretPolicy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SecretsManagerSecretConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SecretsManagerSecretConfiguration(")
        append("kmsKeyId=$kmsKeyId,")
        append("secretPolicy=$secretPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (secretPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SecretsManagerSecretConfiguration

        if (kmsKeyId != other.kmsKeyId) return false
        if (secretPolicy != other.secretPolicy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SecretsManagerSecretConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SecretsManagerSecretConfiguration
        /**
         * The proposed ARN, key ID, or alias of the KMS customer master key (CMK).
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The proposed resource policy defining who can access or manage the secret.
         */
        fun secretPolicy(secretPolicy: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The proposed ARN, key ID, or alias of the KMS customer master key (CMK).
         */
        var kmsKeyId: String?
        /**
         * The proposed resource policy defining who can access or manage the secret.
         */
        var secretPolicy: String?

        fun build(): SecretsManagerSecretConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var kmsKeyId: String? = null
        override var secretPolicy: String? = null

        constructor(x: SecretsManagerSecretConfiguration) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.secretPolicy = x.secretPolicy
        }

        override fun build(): SecretsManagerSecretConfiguration = SecretsManagerSecretConfiguration(this)
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun secretPolicy(secretPolicy: String): FluentBuilder = apply { this.secretPolicy = secretPolicy }
    }
}
