// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The PublicAccessBlock configuration to apply to this Amazon S3 bucket. If the
 * proposed configuration is for an existing Amazon S3 bucket and the configuration is not
 * specified, the access preview uses the existing setting. If the proposed configuration is
 * for a new bucket and the configuration is not specified, the access preview uses
 * false. If the proposed configuration is for a new access point or
 * multi-region access point and the access point BPA configuration is not specified, the
 * access preview uses true. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html">PublicAccessBlockConfiguration.
 */
class S3PublicAccessBlockConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this
     * bucket.
     */
    val ignorePublicAcls: Boolean? = builder.ignorePublicAcls
    /**
     * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
     */
    val restrictPublicBuckets: Boolean? = builder.restrictPublicBuckets

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3PublicAccessBlockConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3PublicAccessBlockConfiguration(")
        append("ignorePublicAcls=$ignorePublicAcls,")
        append("restrictPublicBuckets=$restrictPublicBuckets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ignorePublicAcls?.hashCode() ?: 0
        result = 31 * result + (restrictPublicBuckets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3PublicAccessBlockConfiguration

        if (ignorePublicAcls != other.ignorePublicAcls) return false
        if (restrictPublicBuckets != other.restrictPublicBuckets) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3PublicAccessBlockConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3PublicAccessBlockConfiguration
        /**
         * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this
         * bucket.
         */
        fun ignorePublicAcls(ignorePublicAcls: Boolean): FluentBuilder
        /**
         * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
         */
        fun restrictPublicBuckets(restrictPublicBuckets: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this
         * bucket.
         */
        var ignorePublicAcls: Boolean?
        /**
         * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
         */
        var restrictPublicBuckets: Boolean?

        fun build(): S3PublicAccessBlockConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var ignorePublicAcls: Boolean? = null
        override var restrictPublicBuckets: Boolean? = null

        constructor(x: S3PublicAccessBlockConfiguration) : this() {
            this.ignorePublicAcls = x.ignorePublicAcls
            this.restrictPublicBuckets = x.restrictPublicBuckets
        }

        override fun build(): S3PublicAccessBlockConfiguration = S3PublicAccessBlockConfiguration(this)
        override fun ignorePublicAcls(ignorePublicAcls: Boolean): FluentBuilder = apply { this.ignorePublicAcls = ignorePublicAcls }
        override fun restrictPublicBuckets(restrictPublicBuckets: Boolean): FluentBuilder = apply { this.restrictPublicBuckets = restrictPublicBuckets }
    }
}
