// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Proposed access control configuration for an Amazon S3 bucket. You can propose a
 * configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket that you own by specifying
 * the Amazon S3 bucket policy, bucket ACLs, bucket BPA settings, Amazon S3 access points, and
 * multi-region access points attached to the bucket. If the configuration is for an existing
 * Amazon S3 bucket and you do not specify the Amazon S3 bucket policy, the access preview uses the
 * existing policy attached to the bucket. If the access preview is for a new resource and you
 * do not specify the Amazon S3 bucket policy, the access preview assumes a bucket without a
 * policy. To propose deletion of an existing bucket policy, you can specify an empty string.
 * For more information about bucket policy limits, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html">Bucket Policy
 * Examples.
 */
class S3BucketConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The configuration of Amazon S3 access points or multi-region access points for the bucket.
     * You can propose up to 10 new access points per bucket.
     */
    val accessPoints: Map<String, S3AccessPointConfiguration>? = builder.accessPoints
    /**
     * The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL
     * grants per bucket. If the proposed grant configuration is for an existing bucket, the
     * access preview uses the proposed list of grant configurations in place of the existing
     * grants. Otherwise, the access preview uses the existing grants for the bucket.
     */
    val bucketAclGrants: List<S3BucketAclGrantConfiguration>? = builder.bucketAclGrants
    /**
     * The proposed bucket policy for the Amazon S3 bucket.
     */
    val bucketPolicy: String? = builder.bucketPolicy
    /**
     * The proposed block public access configuration for the Amazon S3 bucket.
     */
    val bucketPublicAccessBlock: S3PublicAccessBlockConfiguration? = builder.bucketPublicAccessBlock

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3BucketConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketConfiguration(")
        append("accessPoints=$accessPoints,")
        append("bucketAclGrants=$bucketAclGrants,")
        append("bucketPolicy=$bucketPolicy,")
        append("bucketPublicAccessBlock=$bucketPublicAccessBlock)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPoints?.hashCode() ?: 0
        result = 31 * result + (bucketAclGrants?.hashCode() ?: 0)
        result = 31 * result + (bucketPolicy?.hashCode() ?: 0)
        result = 31 * result + (bucketPublicAccessBlock?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3BucketConfiguration

        if (accessPoints != other.accessPoints) return false
        if (bucketAclGrants != other.bucketAclGrants) return false
        if (bucketPolicy != other.bucketPolicy) return false
        if (bucketPublicAccessBlock != other.bucketPublicAccessBlock) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3BucketConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3BucketConfiguration
        /**
         * The configuration of Amazon S3 access points or multi-region access points for the bucket.
         * You can propose up to 10 new access points per bucket.
         */
        fun accessPoints(accessPoints: Map<String, S3AccessPointConfiguration>): FluentBuilder
        /**
         * The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL
         * grants per bucket. If the proposed grant configuration is for an existing bucket, the
         * access preview uses the proposed list of grant configurations in place of the existing
         * grants. Otherwise, the access preview uses the existing grants for the bucket.
         */
        fun bucketAclGrants(bucketAclGrants: List<S3BucketAclGrantConfiguration>): FluentBuilder
        /**
         * The proposed bucket policy for the Amazon S3 bucket.
         */
        fun bucketPolicy(bucketPolicy: String): FluentBuilder
        /**
         * The proposed block public access configuration for the Amazon S3 bucket.
         */
        fun bucketPublicAccessBlock(bucketPublicAccessBlock: S3PublicAccessBlockConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The configuration of Amazon S3 access points or multi-region access points for the bucket.
         * You can propose up to 10 new access points per bucket.
         */
        var accessPoints: Map<String, S3AccessPointConfiguration>?
        /**
         * The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL
         * grants per bucket. If the proposed grant configuration is for an existing bucket, the
         * access preview uses the proposed list of grant configurations in place of the existing
         * grants. Otherwise, the access preview uses the existing grants for the bucket.
         */
        var bucketAclGrants: List<S3BucketAclGrantConfiguration>?
        /**
         * The proposed bucket policy for the Amazon S3 bucket.
         */
        var bucketPolicy: String?
        /**
         * The proposed block public access configuration for the Amazon S3 bucket.
         */
        var bucketPublicAccessBlock: S3PublicAccessBlockConfiguration?

        fun build(): S3BucketConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration] inside the given [block]
         */
        fun bucketPublicAccessBlock(block: S3PublicAccessBlockConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.bucketPublicAccessBlock = S3PublicAccessBlockConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessPoints: Map<String, S3AccessPointConfiguration>? = null
        override var bucketAclGrants: List<S3BucketAclGrantConfiguration>? = null
        override var bucketPolicy: String? = null
        override var bucketPublicAccessBlock: S3PublicAccessBlockConfiguration? = null

        constructor(x: S3BucketConfiguration) : this() {
            this.accessPoints = x.accessPoints
            this.bucketAclGrants = x.bucketAclGrants
            this.bucketPolicy = x.bucketPolicy
            this.bucketPublicAccessBlock = x.bucketPublicAccessBlock
        }

        override fun build(): S3BucketConfiguration = S3BucketConfiguration(this)
        override fun accessPoints(accessPoints: Map<String, S3AccessPointConfiguration>): FluentBuilder = apply { this.accessPoints = accessPoints }
        override fun bucketAclGrants(bucketAclGrants: List<S3BucketAclGrantConfiguration>): FluentBuilder = apply { this.bucketAclGrants = bucketAclGrants }
        override fun bucketPolicy(bucketPolicy: String): FluentBuilder = apply { this.bucketPolicy = bucketPolicy }
        override fun bucketPublicAccessBlock(bucketPublicAccessBlock: S3PublicAccessBlockConfiguration): FluentBuilder = apply { this.bucketPublicAccessBlock = bucketPublicAccessBlock }
    }
}
