// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * A proposed access control list grant configuration for an Amazon S3 bucket. For more
 * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls">How to Specify an
 * ACL.
 */
class S3BucketAclGrantConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The grantee to whom you’re assigning access rights.
     */
    val grantee: AclGrantee? = builder.grantee
    /**
     * The permissions being granted.
     */
    val permission: AclPermission? = builder.permission

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3BucketAclGrantConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketAclGrantConfiguration(")
        append("grantee=$grantee,")
        append("permission=$permission)")
    }

    override fun hashCode(): kotlin.Int {
        var result = grantee?.hashCode() ?: 0
        result = 31 * result + (permission?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3BucketAclGrantConfiguration

        if (grantee != other.grantee) return false
        if (permission != other.permission) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3BucketAclGrantConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3BucketAclGrantConfiguration
        /**
         * The grantee to whom you’re assigning access rights.
         */
        fun grantee(grantee: AclGrantee): FluentBuilder
        /**
         * The permissions being granted.
         */
        fun permission(permission: AclPermission): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The grantee to whom you’re assigning access rights.
         */
        var grantee: AclGrantee?
        /**
         * The permissions being granted.
         */
        var permission: AclPermission?

        fun build(): S3BucketAclGrantConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var grantee: AclGrantee? = null
        override var permission: AclPermission? = null

        constructor(x: S3BucketAclGrantConfiguration) : this() {
            this.grantee = x.grantee
            this.permission = x.permission
        }

        override fun build(): S3BucketAclGrantConfiguration = S3BucketAclGrantConfiguration(this)
        override fun grantee(grantee: AclGrantee): FluentBuilder = apply { this.grantee = grantee }
        override fun permission(permission: AclPermission): FluentBuilder = apply { this.permission = permission }
    }
}
