// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The configuration for an Amazon S3 access point or multi-region access point for the bucket.
 * You can propose up to 10 access points or multi-region access points per bucket. If the
 * proposed Amazon S3 access point configuration is for an existing bucket, the access preview uses
 * the proposed access point configuration in place of the existing access points. To propose
 * an access point without a policy, you can provide an empty string as the access point
 * policy. For more information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html">Creating access points. For more information about access point policy limits,
 * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html">Access points
 * restrictions and limitations.
 */
class S3AccessPointConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The access point or multi-region access point policy.
     */
    val accessPointPolicy: String? = builder.accessPointPolicy
    /**
     * The proposed Internet and VpcConfiguration to apply to this
     * Amazon S3 access point. VpcConfiguration does not apply to multi-region access
     * points. If the access preview is for a new resource and neither is specified, the access
     * preview uses Internet for the network origin. If the access preview is for an
     * existing resource and neither is specified, the access preview uses the exiting network
     * origin.
     */
    val networkOrigin: NetworkOriginConfiguration? = builder.networkOrigin
    /**
     * The proposed S3PublicAccessBlock configuration to apply to this Amazon S3 access
     * point or multi-region access point.
     */
    val publicAccessBlock: S3PublicAccessBlockConfiguration? = builder.publicAccessBlock

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3AccessPointConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3AccessPointConfiguration(")
        append("accessPointPolicy=$accessPointPolicy,")
        append("networkOrigin=$networkOrigin,")
        append("publicAccessBlock=$publicAccessBlock)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointPolicy?.hashCode() ?: 0
        result = 31 * result + (networkOrigin?.hashCode() ?: 0)
        result = 31 * result + (publicAccessBlock?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3AccessPointConfiguration

        if (accessPointPolicy != other.accessPointPolicy) return false
        if (networkOrigin != other.networkOrigin) return false
        if (publicAccessBlock != other.publicAccessBlock) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3AccessPointConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3AccessPointConfiguration
        /**
         * The access point or multi-region access point policy.
         */
        fun accessPointPolicy(accessPointPolicy: String): FluentBuilder
        /**
         * The proposed Internet and VpcConfiguration to apply to this
         * Amazon S3 access point. VpcConfiguration does not apply to multi-region access
         * points. If the access preview is for a new resource and neither is specified, the access
         * preview uses Internet for the network origin. If the access preview is for an
         * existing resource and neither is specified, the access preview uses the exiting network
         * origin.
         */
        fun networkOrigin(networkOrigin: NetworkOriginConfiguration): FluentBuilder
        /**
         * The proposed S3PublicAccessBlock configuration to apply to this Amazon S3 access
         * point or multi-region access point.
         */
        fun publicAccessBlock(publicAccessBlock: S3PublicAccessBlockConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The access point or multi-region access point policy.
         */
        var accessPointPolicy: String?
        /**
         * The proposed Internet and VpcConfiguration to apply to this
         * Amazon S3 access point. VpcConfiguration does not apply to multi-region access
         * points. If the access preview is for a new resource and neither is specified, the access
         * preview uses Internet for the network origin. If the access preview is for an
         * existing resource and neither is specified, the access preview uses the exiting network
         * origin.
         */
        var networkOrigin: NetworkOriginConfiguration?
        /**
         * The proposed S3PublicAccessBlock configuration to apply to this Amazon S3 access
         * point or multi-region access point.
         */
        var publicAccessBlock: S3PublicAccessBlockConfiguration?

        fun build(): S3AccessPointConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration] inside the given [block]
         */
        fun publicAccessBlock(block: S3PublicAccessBlockConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.publicAccessBlock = S3PublicAccessBlockConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessPointPolicy: String? = null
        override var networkOrigin: NetworkOriginConfiguration? = null
        override var publicAccessBlock: S3PublicAccessBlockConfiguration? = null

        constructor(x: S3AccessPointConfiguration) : this() {
            this.accessPointPolicy = x.accessPointPolicy
            this.networkOrigin = x.networkOrigin
            this.publicAccessBlock = x.publicAccessBlock
        }

        override fun build(): S3AccessPointConfiguration = S3AccessPointConfiguration(this)
        override fun accessPointPolicy(accessPointPolicy: String): FluentBuilder = apply { this.accessPointPolicy = accessPointPolicy }
        override fun networkOrigin(networkOrigin: NetworkOriginConfiguration): FluentBuilder = apply { this.networkOrigin = networkOrigin }
        override fun publicAccessBlock(publicAccessBlock: S3PublicAccessBlockConfiguration): FluentBuilder = apply { this.publicAccessBlock = publicAccessBlock }
    }
}
