// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the policy generation status and properties.
 */
class PolicyGeneration private constructor(builder: BuilderImpl) {
    /**
     * A timestamp of when the policy generation was completed.
     */
    val completedOn: Instant? = builder.completedOn
    /**
     * The JobId that is returned by the StartPolicyGeneration
     * operation. The JobId can be used with GetGeneratedPolicy to
     * retrieve the generated policies or used with CancelPolicyGeneration to cancel
     * the policy generation request.
     */
    val jobId: String? = builder.jobId
    /**
     * The ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    val principalArn: String? = builder.principalArn
    /**
     * A timestamp of when the policy generation started.
     */
    val startedOn: Instant? = builder.startedOn
    /**
     * The status of the policy generation request.
     */
    val status: JobStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PolicyGeneration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyGeneration(")
        append("completedOn=$completedOn,")
        append("jobId=$jobId,")
        append("principalArn=$principalArn,")
        append("startedOn=$startedOn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completedOn?.hashCode() ?: 0
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (principalArn?.hashCode() ?: 0)
        result = 31 * result + (startedOn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PolicyGeneration

        if (completedOn != other.completedOn) return false
        if (jobId != other.jobId) return false
        if (principalArn != other.principalArn) return false
        if (startedOn != other.startedOn) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PolicyGeneration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PolicyGeneration
        /**
         * A timestamp of when the policy generation was completed.
         */
        fun completedOn(completedOn: Instant): FluentBuilder
        /**
         * The JobId that is returned by the StartPolicyGeneration
         * operation. The JobId can be used with GetGeneratedPolicy to
         * retrieve the generated policies or used with CancelPolicyGeneration to cancel
         * the policy generation request.
         */
        fun jobId(jobId: String): FluentBuilder
        /**
         * The ARN of the IAM entity (user or role) for which you are generating a policy.
         */
        fun principalArn(principalArn: String): FluentBuilder
        /**
         * A timestamp of when the policy generation started.
         */
        fun startedOn(startedOn: Instant): FluentBuilder
        /**
         * The status of the policy generation request.
         */
        fun status(status: JobStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A timestamp of when the policy generation was completed.
         */
        var completedOn: Instant?
        /**
         * The JobId that is returned by the StartPolicyGeneration
         * operation. The JobId can be used with GetGeneratedPolicy to
         * retrieve the generated policies or used with CancelPolicyGeneration to cancel
         * the policy generation request.
         */
        var jobId: String?
        /**
         * The ARN of the IAM entity (user or role) for which you are generating a policy.
         */
        var principalArn: String?
        /**
         * A timestamp of when the policy generation started.
         */
        var startedOn: Instant?
        /**
         * The status of the policy generation request.
         */
        var status: JobStatus?

        fun build(): PolicyGeneration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var completedOn: Instant? = null
        override var jobId: String? = null
        override var principalArn: String? = null
        override var startedOn: Instant? = null
        override var status: JobStatus? = null

        constructor(x: PolicyGeneration) : this() {
            this.completedOn = x.completedOn
            this.jobId = x.jobId
            this.principalArn = x.principalArn
            this.startedOn = x.startedOn
            this.status = x.status
        }

        override fun build(): PolicyGeneration = PolicyGeneration(this)
        override fun completedOn(completedOn: Instant): FluentBuilder = apply { this.completedOn = completedOn }
        override fun jobId(jobId: String): FluentBuilder = apply { this.jobId = jobId }
        override fun principalArn(principalArn: String): FluentBuilder = apply { this.principalArn = principalArn }
        override fun startedOn(startedOn: Instant): FluentBuilder = apply { this.startedOn = startedOn }
        override fun status(status: JobStatus): FluentBuilder = apply { this.status = status }
    }
}
