// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Retrieves a list of findings generated by the specified analyzer.
 */
class ListFindingsRequest private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
     * the analyzer to retrieve findings from.
     */
    val analyzerArn: String? = builder.analyzerArn
    /**
     * A filter to match for the findings to return.
     */
    val filter: Map<String, Criterion>? = builder.filter
    /**
     * The maximum number of results to return in the response.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The sort order for the findings returned.
     */
    val sort: SortCriteria? = builder.sort

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListFindingsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListFindingsRequest(")
        append("analyzerArn=$analyzerArn,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sort=$sort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListFindingsRequest

        if (analyzerArn != other.analyzerArn) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sort != other.sort) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListFindingsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListFindingsRequest
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer to retrieve findings from.
         */
        fun analyzerArn(analyzerArn: String): FluentBuilder
        /**
         * A filter to match for the findings to return.
         */
        fun filter(filter: Map<String, Criterion>): FluentBuilder
        /**
         * The maximum number of results to return in the response.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token used for pagination of results returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The sort order for the findings returned.
         */
        fun sort(sort: SortCriteria): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer to retrieve findings from.
         */
        var analyzerArn: String?
        /**
         * A filter to match for the findings to return.
         */
        var filter: Map<String, Criterion>?
        /**
         * The maximum number of results to return in the response.
         */
        var maxResults: Int?
        /**
         * A token used for pagination of results returned.
         */
        var nextToken: String?
        /**
         * The sort order for the findings returned.
         */
        var sort: SortCriteria?

        fun build(): ListFindingsRequest
        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.SortCriteria] inside the given [block]
         */
        fun sort(block: SortCriteria.DslBuilder.() -> kotlin.Unit) {
            this.sort = SortCriteria.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerArn: String? = null
        override var filter: Map<String, Criterion>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var sort: SortCriteria? = null

        constructor(x: ListFindingsRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sort = x.sort
        }

        override fun build(): ListFindingsRequest = ListFindingsRequest(this)
        override fun analyzerArn(analyzerArn: String): FluentBuilder = apply { this.analyzerArn = analyzerArn }
        override fun filter(filter: Map<String, Criterion>): FluentBuilder = apply { this.filter = filter }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun sort(sort: SortCriteria): FluentBuilder = apply { this.sort = sort }
    }
}
