// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Retrieves a list of archive rules created for the specified analyzer.
 */
class ListArchiveRulesRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the analyzer to retrieve rules from.
     */
    val analyzerName: String? = builder.analyzerName
    /**
     * The maximum number of results to return in the request.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListArchiveRulesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListArchiveRulesRequest(")
        append("analyzerName=$analyzerName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListArchiveRulesRequest

        if (analyzerName != other.analyzerName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListArchiveRulesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListArchiveRulesRequest
        /**
         * The name of the analyzer to retrieve rules from.
         */
        fun analyzerName(analyzerName: String): FluentBuilder
        /**
         * The maximum number of results to return in the request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token used for pagination of results returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the analyzer to retrieve rules from.
         */
        var analyzerName: String?
        /**
         * The maximum number of results to return in the request.
         */
        var maxResults: Int?
        /**
         * A token used for pagination of results returned.
         */
        var nextToken: String?

        fun build(): ListArchiveRulesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerName: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListArchiveRulesRequest) : this() {
            this.analyzerName = x.analyzerName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListArchiveRulesRequest = ListArchiveRulesRequest(this)
        override fun analyzerName(analyzerName: String): FluentBuilder = apply { this.analyzerName = analyzerName }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
