// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Retrieves a list of resources that have been analyzed.
 */
class ListAnalyzedResourcesRequest private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
     * the analyzer to retrieve a list of analyzed resources from.
     */
    val analyzerArn: String? = builder.analyzerArn
    /**
     * The maximum number of results to return in the response.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The type of resource.
     */
    val resourceType: ResourceType? = builder.resourceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListAnalyzedResourcesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListAnalyzedResourcesRequest(")
        append("analyzerArn=$analyzerArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListAnalyzedResourcesRequest

        if (analyzerArn != other.analyzerArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListAnalyzedResourcesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListAnalyzedResourcesRequest
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer to retrieve a list of analyzed resources from.
         */
        fun analyzerArn(analyzerArn: String): FluentBuilder
        /**
         * The maximum number of results to return in the response.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token used for pagination of results returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The type of resource.
         */
        fun resourceType(resourceType: ResourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer to retrieve a list of analyzed resources from.
         */
        var analyzerArn: String?
        /**
         * The maximum number of results to return in the response.
         */
        var maxResults: Int?
        /**
         * A token used for pagination of results returned.
         */
        var nextToken: String?
        /**
         * The type of resource.
         */
        var resourceType: ResourceType?

        fun build(): ListAnalyzedResourcesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerArn: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var resourceType: ResourceType? = null

        constructor(x: ListAnalyzedResourcesRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resourceType = x.resourceType
        }

        override fun build(): ListAnalyzedResourcesRequest = ListAnalyzedResourcesRequest(this)
        override fun analyzerArn(analyzerArn: String): FluentBuilder = apply { this.analyzerArn = analyzerArn }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun resourceType(resourceType: ResourceType): FluentBuilder = apply { this.resourceType = resourceType }
    }
}
