// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



class ListAccessPreviewsRequest private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
     * the analyzer used to generate the access preview.
     */
    val analyzerArn: String? = builder.analyzerArn
    /**
     * The maximum number of results to return in the response.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListAccessPreviewsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListAccessPreviewsRequest(")
        append("analyzerArn=$analyzerArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListAccessPreviewsRequest

        if (analyzerArn != other.analyzerArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListAccessPreviewsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListAccessPreviewsRequest
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer used to generate the access preview.
         */
        fun analyzerArn(analyzerArn: String): FluentBuilder
        /**
         * The maximum number of results to return in the response.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token used for pagination of results returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer used to generate the access preview.
         */
        var analyzerArn: String?
        /**
         * The maximum number of results to return in the response.
         */
        var maxResults: Int?
        /**
         * A token used for pagination of results returned.
         */
        var nextToken: String?

        fun build(): ListAccessPreviewsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerArn: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListAccessPreviewsRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListAccessPreviewsRequest = ListAccessPreviewsRequest(this)
        override fun analyzerArn(analyzerArn: String): FluentBuilder = apply { this.analyzerArn = analyzerArn }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
