// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



class ListAccessPreviewFindingsRequest private constructor(builder: BuilderImpl) {
    /**
     * The unique ID for the access preview.
     */
    val accessPreviewId: String? = builder.accessPreviewId
    /**
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
     * the analyzer used to generate the access.
     */
    val analyzerArn: String? = builder.analyzerArn
    /**
     * Criteria to filter the returned findings.
     */
    val filter: Map<String, Criterion>? = builder.filter
    /**
     * The maximum number of results to return in the response.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListAccessPreviewFindingsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListAccessPreviewFindingsRequest(")
        append("accessPreviewId=$accessPreviewId,")
        append("analyzerArn=$analyzerArn,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPreviewId?.hashCode() ?: 0
        result = 31 * result + (analyzerArn?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListAccessPreviewFindingsRequest

        if (accessPreviewId != other.accessPreviewId) return false
        if (analyzerArn != other.analyzerArn) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListAccessPreviewFindingsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListAccessPreviewFindingsRequest
        /**
         * The unique ID for the access preview.
         */
        fun accessPreviewId(accessPreviewId: String): FluentBuilder
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer used to generate the access.
         */
        fun analyzerArn(analyzerArn: String): FluentBuilder
        /**
         * Criteria to filter the returned findings.
         */
        fun filter(filter: Map<String, Criterion>): FluentBuilder
        /**
         * The maximum number of results to return in the response.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A token used for pagination of results returned.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique ID for the access preview.
         */
        var accessPreviewId: String?
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the analyzer used to generate the access.
         */
        var analyzerArn: String?
        /**
         * Criteria to filter the returned findings.
         */
        var filter: Map<String, Criterion>?
        /**
         * The maximum number of results to return in the response.
         */
        var maxResults: Int?
        /**
         * A token used for pagination of results returned.
         */
        var nextToken: String?

        fun build(): ListAccessPreviewFindingsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessPreviewId: String? = null
        override var analyzerArn: String? = null
        override var filter: Map<String, Criterion>? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListAccessPreviewFindingsRequest) : this() {
            this.accessPreviewId = x.accessPreviewId
            this.analyzerArn = x.analyzerArn
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListAccessPreviewFindingsRequest = ListAccessPreviewFindingsRequest(this)
        override fun accessPreviewId(accessPreviewId: String): FluentBuilder = apply { this.accessPreviewId = accessPreviewId }
        override fun analyzerArn(analyzerArn: String): FluentBuilder = apply { this.analyzerArn = analyzerArn }
        override fun filter(filter: Map<String, Criterion>): FluentBuilder = apply { this.filter = filter }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
