// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Proposed access control configuration for a KMS key. You can propose a configuration
 * for a new KMS key or an existing KMS key that you own by specifying the key policy and
 * KMS grant configuration. If the configuration is for an existing key and you do not
 * specify the key policy, the access preview uses the existing policy for the key. If the
 * access preview is for a new resource and you do not specify the key policy, then the access
 * preview uses the default key policy. The proposed key policy cannot be an empty string. For
 * more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
 * policy. For more information about key policy limits, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html">Resource
 * quotas.
 * <p/>
 */
class KmsKeyConfiguration private constructor(builder: BuilderImpl) {
    /**
     * A list of proposed grant configurations for the KMS key. If the proposed grant
     * configuration is for an existing key, the access preview uses the proposed list of grant
     * configurations in place of the existing grants. Otherwise, the access preview uses the
     * existing grants for the key.
     */
    val grants: List<KmsGrantConfiguration>? = builder.grants
    /**
     * Resource policy configuration for the KMS key. The only valid value for the name of
     * the key policy is default. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
     * policy.
     */
    val keyPolicies: Map<String, String>? = builder.keyPolicies

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KmsKeyConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KmsKeyConfiguration(")
        append("grants=$grants,")
        append("keyPolicies=$keyPolicies)")
    }

    override fun hashCode(): kotlin.Int {
        var result = grants?.hashCode() ?: 0
        result = 31 * result + (keyPolicies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KmsKeyConfiguration

        if (grants != other.grants) return false
        if (keyPolicies != other.keyPolicies) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KmsKeyConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KmsKeyConfiguration
        /**
         * A list of proposed grant configurations for the KMS key. If the proposed grant
         * configuration is for an existing key, the access preview uses the proposed list of grant
         * configurations in place of the existing grants. Otherwise, the access preview uses the
         * existing grants for the key.
         */
        fun grants(grants: List<KmsGrantConfiguration>): FluentBuilder
        /**
         * Resource policy configuration for the KMS key. The only valid value for the name of
         * the key policy is default. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
         * policy.
         */
        fun keyPolicies(keyPolicies: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of proposed grant configurations for the KMS key. If the proposed grant
         * configuration is for an existing key, the access preview uses the proposed list of grant
         * configurations in place of the existing grants. Otherwise, the access preview uses the
         * existing grants for the key.
         */
        var grants: List<KmsGrantConfiguration>?
        /**
         * Resource policy configuration for the KMS key. The only valid value for the name of
         * the key policy is default. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key
         * policy.
         */
        var keyPolicies: Map<String, String>?

        fun build(): KmsKeyConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var grants: List<KmsGrantConfiguration>? = null
        override var keyPolicies: Map<String, String>? = null

        constructor(x: KmsKeyConfiguration) : this() {
            this.grants = x.grants
            this.keyPolicies = x.keyPolicies
        }

        override fun build(): KmsKeyConfiguration = KmsKeyConfiguration(this)
        override fun grants(grants: List<KmsGrantConfiguration>): FluentBuilder = apply { this.grants = grants }
        override fun keyPolicies(keyPolicies: Map<String, String>): FluentBuilder = apply { this.keyPolicies = keyPolicies }
    }
}
