// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
 * operations in the grant only when the operation request includes the specified
 * <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
 * context. You can specify only one type of encryption context. An empty map is
 * treated as not specified. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html">GrantConstraints.
 */
class KmsGrantConstraints private constructor(builder: BuilderImpl) {
    /**
     * A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
     * operation request. The grant allows the operation only when the encryption
     * context in the request is the same as the encryption context specified in this
     * constraint.
     */
    val encryptionContextEquals: Map<String, String>? = builder.encryptionContextEquals
    /**
     * A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
     * operation request. The grant allows the cryptographic operation only when the
     * encryption context in the request includes the key-value pairs specified in this
     * constraint, although it can include additional key-value pairs.
     */
    val encryptionContextSubset: Map<String, String>? = builder.encryptionContextSubset

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KmsGrantConstraints = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KmsGrantConstraints(")
        append("encryptionContextEquals=$encryptionContextEquals,")
        append("encryptionContextSubset=$encryptionContextSubset)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionContextEquals?.hashCode() ?: 0
        result = 31 * result + (encryptionContextSubset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KmsGrantConstraints

        if (encryptionContextEquals != other.encryptionContextEquals) return false
        if (encryptionContextSubset != other.encryptionContextSubset) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KmsGrantConstraints = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KmsGrantConstraints
        /**
         * A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
         * operation request. The grant allows the operation only when the encryption
         * context in the request is the same as the encryption context specified in this
         * constraint.
         */
        fun encryptionContextEquals(encryptionContextEquals: Map<String, String>): FluentBuilder
        /**
         * A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
         * operation request. The grant allows the cryptographic operation only when the
         * encryption context in the request includes the key-value pairs specified in this
         * constraint, although it can include additional key-value pairs.
         */
        fun encryptionContextSubset(encryptionContextSubset: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of key-value pairs that must match the encryption context in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
         * operation request. The grant allows the operation only when the encryption
         * context in the request is the same as the encryption context specified in this
         * constraint.
         */
        var encryptionContextEquals: Map<String, String>?
        /**
         * A list of key-value pairs that must be included in the encryption context of the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
         * operation request. The grant allows the cryptographic operation only when the
         * encryption context in the request includes the key-value pairs specified in this
         * constraint, although it can include additional key-value pairs.
         */
        var encryptionContextSubset: Map<String, String>?

        fun build(): KmsGrantConstraints
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var encryptionContextEquals: Map<String, String>? = null
        override var encryptionContextSubset: Map<String, String>? = null

        constructor(x: KmsGrantConstraints) : this() {
            this.encryptionContextEquals = x.encryptionContextEquals
            this.encryptionContextSubset = x.encryptionContextSubset
        }

        override fun build(): KmsGrantConstraints = KmsGrantConstraints(this)
        override fun encryptionContextEquals(encryptionContextEquals: Map<String, String>): FluentBuilder = apply { this.encryptionContextEquals = encryptionContextEquals }
        override fun encryptionContextSubset(encryptionContextSubset: Map<String, String>): FluentBuilder = apply { this.encryptionContextSubset = encryptionContextSubset }
    }
}
