// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * A proposed grant configuration for a KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant.
 */
class KmsGrantConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
     * operations in the grant only when the operation request includes the specified
     * <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
     * context.
     */
    val constraints: KmsGrantConstraints? = builder.constraints
    /**
     * The principal that is given permission to perform the operations that the grant
     * permits.
     */
    val granteePrincipal: String? = builder.granteePrincipal
    /**
     * The Amazon Web Services account under which the grant was issued. The account is used to propose
     * KMS grants issued by accounts other than the owner of the key.
     */
    val issuingAccount: String? = builder.issuingAccount
    /**
     * A list of operations that the grant permits.
     */
    val operations: List<KmsGrantOperation>? = builder.operations
    /**
     * The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant operation.
     */
    val retiringPrincipal: String? = builder.retiringPrincipal

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KmsGrantConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KmsGrantConfiguration(")
        append("constraints=$constraints,")
        append("granteePrincipal=$granteePrincipal,")
        append("issuingAccount=$issuingAccount,")
        append("operations=$operations,")
        append("retiringPrincipal=$retiringPrincipal)")
    }

    override fun hashCode(): kotlin.Int {
        var result = constraints?.hashCode() ?: 0
        result = 31 * result + (granteePrincipal?.hashCode() ?: 0)
        result = 31 * result + (issuingAccount?.hashCode() ?: 0)
        result = 31 * result + (operations?.hashCode() ?: 0)
        result = 31 * result + (retiringPrincipal?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KmsGrantConfiguration

        if (constraints != other.constraints) return false
        if (granteePrincipal != other.granteePrincipal) return false
        if (issuingAccount != other.issuingAccount) return false
        if (operations != other.operations) return false
        if (retiringPrincipal != other.retiringPrincipal) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KmsGrantConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KmsGrantConfiguration
        /**
         * Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
         * operations in the grant only when the operation request includes the specified
         * <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
         * context.
         */
        fun constraints(constraints: KmsGrantConstraints): FluentBuilder
        /**
         * The principal that is given permission to perform the operations that the grant
         * permits.
         */
        fun granteePrincipal(granteePrincipal: String): FluentBuilder
        /**
         * The Amazon Web Services account under which the grant was issued. The account is used to propose
         * KMS grants issued by accounts other than the owner of the key.
         */
        fun issuingAccount(issuingAccount: String): FluentBuilder
        /**
         * A list of operations that the grant permits.
         */
        fun operations(operations: List<KmsGrantOperation>): FluentBuilder
        /**
         * The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant operation.
         */
        fun retiringPrincipal(retiringPrincipal: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Use this structure to propose allowing <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic
         * operations in the grant only when the operation request includes the specified
         * <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">encryption
         * context.
         */
        var constraints: KmsGrantConstraints?
        /**
         * The principal that is given permission to perform the operations that the grant
         * permits.
         */
        var granteePrincipal: String?
        /**
         * The Amazon Web Services account under which the grant was issued. The account is used to propose
         * KMS grants issued by accounts other than the owner of the key.
         */
        var issuingAccount: String?
        /**
         * A list of operations that the grant permits.
         */
        var operations: List<KmsGrantOperation>?
        /**
         * The principal that is given permission to retire the grant by using <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html">RetireGrant operation.
         */
        var retiringPrincipal: String?

        fun build(): KmsGrantConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.KmsGrantConstraints] inside the given [block]
         */
        fun constraints(block: KmsGrantConstraints.DslBuilder.() -> kotlin.Unit) {
            this.constraints = KmsGrantConstraints.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var constraints: KmsGrantConstraints? = null
        override var granteePrincipal: String? = null
        override var issuingAccount: String? = null
        override var operations: List<KmsGrantOperation>? = null
        override var retiringPrincipal: String? = null

        constructor(x: KmsGrantConfiguration) : this() {
            this.constraints = x.constraints
            this.granteePrincipal = x.granteePrincipal
            this.issuingAccount = x.issuingAccount
            this.operations = x.operations
            this.retiringPrincipal = x.retiringPrincipal
        }

        override fun build(): KmsGrantConfiguration = KmsGrantConfiguration(this)
        override fun constraints(constraints: KmsGrantConstraints): FluentBuilder = apply { this.constraints = constraints }
        override fun granteePrincipal(granteePrincipal: String): FluentBuilder = apply { this.granteePrincipal = granteePrincipal }
        override fun issuingAccount(issuingAccount: String): FluentBuilder = apply { this.issuingAccount = issuingAccount }
        override fun operations(operations: List<KmsGrantOperation>): FluentBuilder = apply { this.operations = operations }
        override fun retiringPrincipal(retiringPrincipal: String): FluentBuilder = apply { this.retiringPrincipal = retiringPrincipal }
    }
}
