// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the policy generation request.
 */
class JobDetails private constructor(builder: BuilderImpl) {
    /**
     * A timestamp of when the job was completed.
     */
    val completedOn: Instant? = builder.completedOn
    /**
     * The job error for the policy generation request.
     */
    val jobError: JobError? = builder.jobError
    /**
     * The JobId that is returned by the StartPolicyGeneration
     * operation. The JobId can be used with GetGeneratedPolicy to
     * retrieve the generated policies or used with CancelPolicyGeneration to cancel
     * the policy generation request.
     */
    val jobId: String? = builder.jobId
    /**
     * A timestamp of when the job was started.
     */
    val startedOn: Instant? = builder.startedOn
    /**
     * The status of the job request.
     */
    val status: JobStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): JobDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("JobDetails(")
        append("completedOn=$completedOn,")
        append("jobError=$jobError,")
        append("jobId=$jobId,")
        append("startedOn=$startedOn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completedOn?.hashCode() ?: 0
        result = 31 * result + (jobError?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (startedOn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as JobDetails

        if (completedOn != other.completedOn) return false
        if (jobError != other.jobError) return false
        if (jobId != other.jobId) return false
        if (startedOn != other.startedOn) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): JobDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): JobDetails
        /**
         * A timestamp of when the job was completed.
         */
        fun completedOn(completedOn: Instant): FluentBuilder
        /**
         * The job error for the policy generation request.
         */
        fun jobError(jobError: JobError): FluentBuilder
        /**
         * The JobId that is returned by the StartPolicyGeneration
         * operation. The JobId can be used with GetGeneratedPolicy to
         * retrieve the generated policies or used with CancelPolicyGeneration to cancel
         * the policy generation request.
         */
        fun jobId(jobId: String): FluentBuilder
        /**
         * A timestamp of when the job was started.
         */
        fun startedOn(startedOn: Instant): FluentBuilder
        /**
         * The status of the job request.
         */
        fun status(status: JobStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A timestamp of when the job was completed.
         */
        var completedOn: Instant?
        /**
         * The job error for the policy generation request.
         */
        var jobError: JobError?
        /**
         * The JobId that is returned by the StartPolicyGeneration
         * operation. The JobId can be used with GetGeneratedPolicy to
         * retrieve the generated policies or used with CancelPolicyGeneration to cancel
         * the policy generation request.
         */
        var jobId: String?
        /**
         * A timestamp of when the job was started.
         */
        var startedOn: Instant?
        /**
         * The status of the job request.
         */
        var status: JobStatus?

        fun build(): JobDetails
        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.JobError] inside the given [block]
         */
        fun jobError(block: JobError.DslBuilder.() -> kotlin.Unit) {
            this.jobError = JobError.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var completedOn: Instant? = null
        override var jobError: JobError? = null
        override var jobId: String? = null
        override var startedOn: Instant? = null
        override var status: JobStatus? = null

        constructor(x: JobDetails) : this() {
            this.completedOn = x.completedOn
            this.jobError = x.jobError
            this.jobId = x.jobId
            this.startedOn = x.startedOn
            this.status = x.status
        }

        override fun build(): JobDetails = JobDetails(this)
        override fun completedOn(completedOn: Instant): FluentBuilder = apply { this.completedOn = completedOn }
        override fun jobError(jobError: JobError): FluentBuilder = apply { this.jobError = jobError }
        override fun jobId(jobId: String): FluentBuilder = apply { this.jobId = jobId }
        override fun startedOn(startedOn: Instant): FluentBuilder = apply { this.startedOn = startedOn }
        override fun status(status: JobStatus): FluentBuilder = apply { this.status = status }
    }
}
