// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The proposed access control configuration for an IAM role. You can propose a
 * configuration for a new IAM role or an existing IAM role that you own by specifying the
 * trust policy. If the configuration is for a new IAM role, you must specify the trust
 * policy. If the configuration is for an existing IAM role that you own and you do not
 * propose the trust policy, the access preview uses the existing trust policy for the role.
 * The proposed trust policy cannot be an empty string. For more information about role trust
 * policy limits, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
 * quotas.
 */
class IamRoleConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The proposed trust policy for the IAM role.
     */
    val trustPolicy: String? = builder.trustPolicy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IamRoleConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IamRoleConfiguration(")
        append("trustPolicy=$trustPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = trustPolicy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IamRoleConfiguration

        if (trustPolicy != other.trustPolicy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IamRoleConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IamRoleConfiguration
        /**
         * The proposed trust policy for the IAM role.
         */
        fun trustPolicy(trustPolicy: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The proposed trust policy for the IAM role.
         */
        var trustPolicy: String?

        fun build(): IamRoleConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var trustPolicy: String? = null

        constructor(x: IamRoleConfiguration) : this() {
            this.trustPolicy = x.trustPolicy
        }

        override fun build(): IamRoleConfiguration = IamRoleConfiguration(this)
        override fun trustPolicy(trustPolicy: String): FluentBuilder = apply { this.trustPolicy = trustPolicy }
    }
}
