// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a finding.
 */
class Finding private constructor(builder: BuilderImpl) {
    /**
     * The action in the analyzed policy statement that an external principal has permission to
     * use.
     */
    val action: List<String>? = builder.action
    /**
     * The time at which the resource was analyzed.
     */
    val analyzedAt: Instant? = builder.analyzedAt
    /**
     * The condition in the analyzed policy statement that resulted in a finding.
     */
    val condition: Map<String, String>? = builder.condition
    /**
     * The time at which the finding was generated.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * An error.
     */
    val error: String? = builder.error
    /**
     * The ID of the finding.
     */
    val id: String? = builder.id
    /**
     * Indicates whether the policy that generated the finding allows public access to the
     * resource.
     */
    val isPublic: Boolean? = builder.isPublic
    /**
     * The external principal that access to a resource within the zone of trust.
     */
    val principal: Map<String, String>? = builder.principal
    /**
     * The resource that an external principal has access to.
     */
    val resource: String? = builder.resource
    /**
     * The Amazon Web Services account ID that owns the resource.
     */
    val resourceOwnerAccount: String? = builder.resourceOwnerAccount
    /**
     * The type of the resource identified in the finding.
     */
    val resourceType: ResourceType? = builder.resourceType
    /**
     * The sources of the finding. This indicates how the access that generated the finding is
     * granted. It is populated for Amazon S3 bucket findings.
     */
    val sources: List<FindingSource>? = builder.sources
    /**
     * The current status of the finding.
     */
    val status: FindingStatus? = builder.status
    /**
     * The time at which the finding was updated.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Finding = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Finding(")
        append("action=$action,")
        append("analyzedAt=$analyzedAt,")
        append("condition=$condition,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("id=$id,")
        append("isPublic=$isPublic,")
        append("principal=$principal,")
        append("resource=$resource,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("sources=$sources,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (analyzedAt?.hashCode() ?: 0)
        result = 31 * result + (condition?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isPublic?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerAccount?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Finding

        if (action != other.action) return false
        if (analyzedAt != other.analyzedAt) return false
        if (condition != other.condition) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (id != other.id) return false
        if (isPublic != other.isPublic) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (sources != other.sources) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Finding = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Finding
        /**
         * The action in the analyzed policy statement that an external principal has permission to
         * use.
         */
        fun action(action: List<String>): FluentBuilder
        /**
         * The time at which the resource was analyzed.
         */
        fun analyzedAt(analyzedAt: Instant): FluentBuilder
        /**
         * The condition in the analyzed policy statement that resulted in a finding.
         */
        fun condition(condition: Map<String, String>): FluentBuilder
        /**
         * The time at which the finding was generated.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * An error.
         */
        fun error(error: String): FluentBuilder
        /**
         * The ID of the finding.
         */
        fun id(id: String): FluentBuilder
        /**
         * Indicates whether the policy that generated the finding allows public access to the
         * resource.
         */
        fun isPublic(isPublic: Boolean): FluentBuilder
        /**
         * The external principal that access to a resource within the zone of trust.
         */
        fun principal(principal: Map<String, String>): FluentBuilder
        /**
         * The resource that an external principal has access to.
         */
        fun resource(resource: String): FluentBuilder
        /**
         * The Amazon Web Services account ID that owns the resource.
         */
        fun resourceOwnerAccount(resourceOwnerAccount: String): FluentBuilder
        /**
         * The type of the resource identified in the finding.
         */
        fun resourceType(resourceType: ResourceType): FluentBuilder
        /**
         * The sources of the finding. This indicates how the access that generated the finding is
         * granted. It is populated for Amazon S3 bucket findings.
         */
        fun sources(sources: List<FindingSource>): FluentBuilder
        /**
         * The current status of the finding.
         */
        fun status(status: FindingStatus): FluentBuilder
        /**
         * The time at which the finding was updated.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action in the analyzed policy statement that an external principal has permission to
         * use.
         */
        var action: List<String>?
        /**
         * The time at which the resource was analyzed.
         */
        var analyzedAt: Instant?
        /**
         * The condition in the analyzed policy statement that resulted in a finding.
         */
        var condition: Map<String, String>?
        /**
         * The time at which the finding was generated.
         */
        var createdAt: Instant?
        /**
         * An error.
         */
        var error: String?
        /**
         * The ID of the finding.
         */
        var id: String?
        /**
         * Indicates whether the policy that generated the finding allows public access to the
         * resource.
         */
        var isPublic: Boolean?
        /**
         * The external principal that access to a resource within the zone of trust.
         */
        var principal: Map<String, String>?
        /**
         * The resource that an external principal has access to.
         */
        var resource: String?
        /**
         * The Amazon Web Services account ID that owns the resource.
         */
        var resourceOwnerAccount: String?
        /**
         * The type of the resource identified in the finding.
         */
        var resourceType: ResourceType?
        /**
         * The sources of the finding. This indicates how the access that generated the finding is
         * granted. It is populated for Amazon S3 bucket findings.
         */
        var sources: List<FindingSource>?
        /**
         * The current status of the finding.
         */
        var status: FindingStatus?
        /**
         * The time at which the finding was updated.
         */
        var updatedAt: Instant?

        fun build(): Finding
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: List<String>? = null
        override var analyzedAt: Instant? = null
        override var condition: Map<String, String>? = null
        override var createdAt: Instant? = null
        override var error: String? = null
        override var id: String? = null
        override var isPublic: Boolean? = null
        override var principal: Map<String, String>? = null
        override var resource: String? = null
        override var resourceOwnerAccount: String? = null
        override var resourceType: ResourceType? = null
        override var sources: List<FindingSource>? = null
        override var status: FindingStatus? = null
        override var updatedAt: Instant? = null

        constructor(x: Finding) : this() {
            this.action = x.action
            this.analyzedAt = x.analyzedAt
            this.condition = x.condition
            this.createdAt = x.createdAt
            this.error = x.error
            this.id = x.id
            this.isPublic = x.isPublic
            this.principal = x.principal
            this.resource = x.resource
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.sources = x.sources
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        override fun build(): Finding = Finding(this)
        override fun action(action: List<String>): FluentBuilder = apply { this.action = action }
        override fun analyzedAt(analyzedAt: Instant): FluentBuilder = apply { this.analyzedAt = analyzedAt }
        override fun condition(condition: Map<String, String>): FluentBuilder = apply { this.condition = condition }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun error(error: String): FluentBuilder = apply { this.error = error }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun isPublic(isPublic: Boolean): FluentBuilder = apply { this.isPublic = isPublic }
        override fun principal(principal: Map<String, String>): FluentBuilder = apply { this.principal = principal }
        override fun resource(resource: String): FluentBuilder = apply { this.resource = resource }
        override fun resourceOwnerAccount(resourceOwnerAccount: String): FluentBuilder = apply { this.resourceOwnerAccount = resourceOwnerAccount }
        override fun resourceType(resourceType: ResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun sources(sources: List<FindingSource>): FluentBuilder = apply { this.sources = sources }
        override fun status(status: FindingStatus): FluentBuilder = apply { this.status = status }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
