// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Creates an analyzer.
 */
class CreateAnalyzerRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the analyzer to create.
     */
    val analyzerName: String? = builder.analyzerName
    /**
     * Specifies the archive rules to add for the analyzer. Archive rules automatically archive
     * findings that meet the criteria you define for the rule.
     */
    val archiveRules: List<InlineArchiveRule>? = builder.archiveRules
    /**
     * A client token.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The tags to apply to the analyzer.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported.
     * You can create only one analyzer per account per Region. You can create up to 5 analyzers
     * per organization per Region.
     */
    val type: Type? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateAnalyzerRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAnalyzerRequest(")
        append("analyzerName=$analyzerName,")
        append("archiveRules=$archiveRules,")
        append("clientToken=$clientToken,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerName?.hashCode() ?: 0
        result = 31 * result + (archiveRules?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateAnalyzerRequest

        if (analyzerName != other.analyzerName) return false
        if (archiveRules != other.archiveRules) return false
        if (clientToken != other.clientToken) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateAnalyzerRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateAnalyzerRequest
        /**
         * The name of the analyzer to create.
         */
        fun analyzerName(analyzerName: String): FluentBuilder
        /**
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive
         * findings that meet the criteria you define for the rule.
         */
        fun archiveRules(archiveRules: List<InlineArchiveRule>): FluentBuilder
        /**
         * A client token.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The tags to apply to the analyzer.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported.
         * You can create only one analyzer per account per Region. You can create up to 5 analyzers
         * per organization per Region.
         */
        fun type(type: Type): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the analyzer to create.
         */
        var analyzerName: String?
        /**
         * Specifies the archive rules to add for the analyzer. Archive rules automatically archive
         * findings that meet the criteria you define for the rule.
         */
        var archiveRules: List<InlineArchiveRule>?
        /**
         * A client token.
         */
        var clientToken: String?
        /**
         * The tags to apply to the analyzer.
         */
        var tags: Map<String, String>?
        /**
         * The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported.
         * You can create only one analyzer per account per Region. You can create up to 5 analyzers
         * per organization per Region.
         */
        var type: Type?

        fun build(): CreateAnalyzerRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerName: String? = null
        override var archiveRules: List<InlineArchiveRule>? = null
        override var clientToken: String? = null
        override var tags: Map<String, String>? = null
        override var type: Type? = null

        constructor(x: CreateAnalyzerRequest) : this() {
            this.analyzerName = x.analyzerName
            this.archiveRules = x.archiveRules
            this.clientToken = x.clientToken
            this.tags = x.tags
            this.type = x.type
        }

        override fun build(): CreateAnalyzerRequest = CreateAnalyzerRequest(this)
        override fun analyzerName(analyzerName: String): FluentBuilder = apply { this.analyzerName = analyzerName }
        override fun archiveRules(archiveRules: List<InlineArchiveRule>): FluentBuilder = apply { this.archiveRules = archiveRules }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: Type): FluentBuilder = apply { this.type = type }
    }
}
