// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



class CreateAccessPreviewRequest private constructor(builder: BuilderImpl) {
    /**
     * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
     * the account analyzer used to generate the access preview. You can only create an
     * access preview for analyzers with an Account type and Active
     * status.
     */
    val analyzerArn: String? = builder.analyzerArn
    /**
     * A client token.
     */
    val clientToken: String? = builder.clientToken
    /**
     * Access control configuration for your resource that is used to generate the access
     * preview. The access preview includes findings for external access allowed to the resource
     * with the proposed access control configuration. The configuration must contain exactly one
     * element.
     */
    val configurations: Map<String, Configuration>? = builder.configurations

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateAccessPreviewRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessPreviewRequest(")
        append("analyzerArn=$analyzerArn,")
        append("clientToken=$clientToken,")
        append("configurations=$configurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateAccessPreviewRequest

        if (analyzerArn != other.analyzerArn) return false
        if (clientToken != other.clientToken) return false
        if (configurations != other.configurations) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateAccessPreviewRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateAccessPreviewRequest
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the account analyzer used to generate the access preview. You can only create an
         * access preview for analyzers with an Account type and Active
         * status.
         */
        fun analyzerArn(analyzerArn: String): FluentBuilder
        /**
         * A client token.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * Access control configuration for your resource that is used to generate the access
         * preview. The access preview includes findings for external access allowed to the resource
         * with the proposed access control configuration. The configuration must contain exactly one
         * element.
         */
        fun configurations(configurations: Map<String, Configuration>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources">ARN of
         * the account analyzer used to generate the access preview. You can only create an
         * access preview for analyzers with an Account type and Active
         * status.
         */
        var analyzerArn: String?
        /**
         * A client token.
         */
        var clientToken: String?
        /**
         * Access control configuration for your resource that is used to generate the access
         * preview. The access preview includes findings for external access allowed to the resource
         * with the proposed access control configuration. The configuration must contain exactly one
         * element.
         */
        var configurations: Map<String, Configuration>?

        fun build(): CreateAccessPreviewRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerArn: String? = null
        override var clientToken: String? = null
        override var configurations: Map<String, Configuration>? = null

        constructor(x: CreateAccessPreviewRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.clientToken = x.clientToken
            this.configurations = x.configurations
        }

        override fun build(): CreateAccessPreviewRequest = CreateAccessPreviewRequest(this)
        override fun analyzerArn(analyzerArn: String): FluentBuilder = apply { this.analyzerArn = analyzerArn }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun configurations(configurations: Map<String, Configuration>): FluentBuilder = apply { this.configurations = configurations }
    }
}
