// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about CloudTrail access.
 */
class CloudTrailProperties private constructor(builder: BuilderImpl) {
    /**
     * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
     * a timestamp after this time are not considered to generate a policy. If this is not
     * included in the request, the default value is the current time.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
     * with a timestamp before this time are not considered to generate a policy.
     */
    val startTime: Instant? = builder.startTime
    /**
     * A TrailProperties object that contains settings for trail
     * properties.
     */
    val trailProperties: List<TrailProperties>? = builder.trailProperties

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudTrailProperties = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudTrailProperties(")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("trailProperties=$trailProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (trailProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudTrailProperties

        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (trailProperties != other.trailProperties) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudTrailProperties = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudTrailProperties
        /**
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
         * a timestamp after this time are not considered to generate a policy. If this is not
         * included in the request, the default value is the current time.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
         * with a timestamp before this time are not considered to generate a policy.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * A TrailProperties object that contains settings for trail
         * properties.
         */
        fun trailProperties(trailProperties: List<TrailProperties>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
         * a timestamp after this time are not considered to generate a policy. If this is not
         * included in the request, the default value is the current time.
         */
        var endTime: Instant?
        /**
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
         * with a timestamp before this time are not considered to generate a policy.
         */
        var startTime: Instant?
        /**
         * A TrailProperties object that contains settings for trail
         * properties.
         */
        var trailProperties: List<TrailProperties>?

        fun build(): CloudTrailProperties
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var startTime: Instant? = null
        override var trailProperties: List<TrailProperties>? = null

        constructor(x: CloudTrailProperties) : this() {
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.trailProperties = x.trailProperties
        }

        override fun build(): CloudTrailProperties = CloudTrailProperties(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun trailProperties(trailProperties: List<TrailProperties>): FluentBuilder = apply { this.trailProperties = trailProperties }
    }
}
