// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about CloudTrail access.
 */
class CloudTrailDetails private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and
     * service last accessed information.
     */
    val accessRole: String? = builder.accessRole
    /**
     * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
     * a timestamp after this time are not considered to generate a policy. If this is not
     * included in the request, the default value is the current time.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
     * with a timestamp before this time are not considered to generate a policy.
     */
    val startTime: Instant? = builder.startTime
    /**
     * A Trail object that contains settings for a trail.
     */
    val trails: List<Trail>? = builder.trails

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CloudTrailDetails = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CloudTrailDetails(")
        append("accessRole=$accessRole,")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("trails=$trails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessRole?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (trails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CloudTrailDetails

        if (accessRole != other.accessRole) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (trails != other.trails) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CloudTrailDetails = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CloudTrailDetails
        /**
         * The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and
         * service last accessed information.
         */
        fun accessRole(accessRole: String): FluentBuilder
        /**
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
         * a timestamp after this time are not considered to generate a policy. If this is not
         * included in the request, the default value is the current time.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
         * with a timestamp before this time are not considered to generate a policy.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * A Trail object that contains settings for a trail.
         */
        fun trails(trails: List<Trail>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and
         * service last accessed information.
         */
        var accessRole: String?
        /**
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
         * a timestamp after this time are not considered to generate a policy. If this is not
         * included in the request, the default value is the current time.
         */
        var endTime: Instant?
        /**
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events
         * with a timestamp before this time are not considered to generate a policy.
         */
        var startTime: Instant?
        /**
         * A Trail object that contains settings for a trail.
         */
        var trails: List<Trail>?

        fun build(): CloudTrailDetails
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessRole: String? = null
        override var endTime: Instant? = null
        override var startTime: Instant? = null
        override var trails: List<Trail>? = null

        constructor(x: CloudTrailDetails) : this() {
            this.accessRole = x.accessRole
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.trails = x.trails
        }

        override fun build(): CloudTrailDetails = CloudTrailDetails(this)
        override fun accessRole(accessRole: String): FluentBuilder = apply { this.accessRole = accessRole }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun trails(trails: List<Trail>): FluentBuilder = apply { this.trails = trails }
    }
}
