// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about the analyzer.
 */
class AnalyzerSummary private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the analyzer.
     */
    val arn: String? = builder.arn
    /**
     * A timestamp for the time at which the analyzer was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The resource that was most recently analyzed by the analyzer.
     */
    val lastResourceAnalyzed: String? = builder.lastResourceAnalyzed
    /**
     * The time at which the most recently analyzed resource was analyzed.
     */
    val lastResourceAnalyzedAt: Instant? = builder.lastResourceAnalyzedAt
    /**
     * The name of the analyzer.
     */
    val name: String? = builder.name
    /**
     * The status of the analyzer. An Active analyzer successfully monitors
     * supported resources and generates new findings. The analyzer is Disabled when
     * a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes
     * the analyzer to stop generating new findings. The status is Creating when the
     * analyzer creation is in progress and Failed when the analyzer creation has
     * failed.
     */
    val status: AnalyzerStatus? = builder.status
    /**
     * The statusReason provides more details about the current status of the
     * analyzer. For example, if the creation for the analyzer fails, a Failed status
     * is returned. For an analyzer with organization as the type, this failure can be due to an
     * issue with creating the service-linked roles required in the member accounts of the Amazon Web Services
     * organization.
     */
    val statusReason: StatusReason? = builder.statusReason
    /**
     * The tags added to the analyzer.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of analyzer, which corresponds to the zone of trust chosen for the
     * analyzer.
     */
    val type: Type? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AnalyzerSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyzerSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("lastResourceAnalyzed=$lastResourceAnalyzed,")
        append("lastResourceAnalyzedAt=$lastResourceAnalyzedAt,")
        append("name=$name,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (lastResourceAnalyzed?.hashCode() ?: 0)
        result = 31 * result + (lastResourceAnalyzedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AnalyzerSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (lastResourceAnalyzed != other.lastResourceAnalyzed) return false
        if (lastResourceAnalyzedAt != other.lastResourceAnalyzedAt) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AnalyzerSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AnalyzerSummary
        /**
         * The ARN of the analyzer.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * A timestamp for the time at which the analyzer was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The resource that was most recently analyzed by the analyzer.
         */
        fun lastResourceAnalyzed(lastResourceAnalyzed: String): FluentBuilder
        /**
         * The time at which the most recently analyzed resource was analyzed.
         */
        fun lastResourceAnalyzedAt(lastResourceAnalyzedAt: Instant): FluentBuilder
        /**
         * The name of the analyzer.
         */
        fun name(name: String): FluentBuilder
        /**
         * The status of the analyzer. An Active analyzer successfully monitors
         * supported resources and generates new findings. The analyzer is Disabled when
         * a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes
         * the analyzer to stop generating new findings. The status is Creating when the
         * analyzer creation is in progress and Failed when the analyzer creation has
         * failed.
         */
        fun status(status: AnalyzerStatus): FluentBuilder
        /**
         * The statusReason provides more details about the current status of the
         * analyzer. For example, if the creation for the analyzer fails, a Failed status
         * is returned. For an analyzer with organization as the type, this failure can be due to an
         * issue with creating the service-linked roles required in the member accounts of the Amazon Web Services
         * organization.
         */
        fun statusReason(statusReason: StatusReason): FluentBuilder
        /**
         * The tags added to the analyzer.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The type of analyzer, which corresponds to the zone of trust chosen for the
         * analyzer.
         */
        fun type(type: Type): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the analyzer.
         */
        var arn: String?
        /**
         * A timestamp for the time at which the analyzer was created.
         */
        var createdAt: Instant?
        /**
         * The resource that was most recently analyzed by the analyzer.
         */
        var lastResourceAnalyzed: String?
        /**
         * The time at which the most recently analyzed resource was analyzed.
         */
        var lastResourceAnalyzedAt: Instant?
        /**
         * The name of the analyzer.
         */
        var name: String?
        /**
         * The status of the analyzer. An Active analyzer successfully monitors
         * supported resources and generates new findings. The analyzer is Disabled when
         * a user action, such as removing trusted access for Identity and Access Management Access Analyzer from Organizations, causes
         * the analyzer to stop generating new findings. The status is Creating when the
         * analyzer creation is in progress and Failed when the analyzer creation has
         * failed.
         */
        var status: AnalyzerStatus?
        /**
         * The statusReason provides more details about the current status of the
         * analyzer. For example, if the creation for the analyzer fails, a Failed status
         * is returned. For an analyzer with organization as the type, this failure can be due to an
         * issue with creating the service-linked roles required in the member accounts of the Amazon Web Services
         * organization.
         */
        var statusReason: StatusReason?
        /**
         * The tags added to the analyzer.
         */
        var tags: Map<String, String>?
        /**
         * The type of analyzer, which corresponds to the zone of trust chosen for the
         * analyzer.
         */
        var type: Type?

        fun build(): AnalyzerSummary
        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.StatusReason] inside the given [block]
         */
        fun statusReason(block: StatusReason.DslBuilder.() -> kotlin.Unit) {
            this.statusReason = StatusReason.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var createdAt: Instant? = null
        override var lastResourceAnalyzed: String? = null
        override var lastResourceAnalyzedAt: Instant? = null
        override var name: String? = null
        override var status: AnalyzerStatus? = null
        override var statusReason: StatusReason? = null
        override var tags: Map<String, String>? = null
        override var type: Type? = null

        constructor(x: AnalyzerSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.lastResourceAnalyzed = x.lastResourceAnalyzed
            this.lastResourceAnalyzedAt = x.lastResourceAnalyzedAt
            this.name = x.name
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
            this.type = x.type
        }

        override fun build(): AnalyzerSummary = AnalyzerSummary(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun lastResourceAnalyzed(lastResourceAnalyzed: String): FluentBuilder = apply { this.lastResourceAnalyzed = lastResourceAnalyzed }
        override fun lastResourceAnalyzedAt(lastResourceAnalyzedAt: Instant): FluentBuilder = apply { this.lastResourceAnalyzedAt = lastResourceAnalyzedAt }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun status(status: AnalyzerStatus): FluentBuilder = apply { this.status = status }
        override fun statusReason(statusReason: StatusReason): FluentBuilder = apply { this.statusReason = statusReason }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: Type): FluentBuilder = apply { this.type = type }
    }
}
