// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the analyzed resource.
 */
class AnalyzedResource private constructor(builder: BuilderImpl) {
    /**
     * The actions that an external principal is granted permission to use by the policy that
     * generated the finding.
     */
    val actions: List<String>? = builder.actions
    /**
     * The time at which the resource was analyzed.
     */
    val analyzedAt: Instant? = builder.analyzedAt
    /**
     * The time at which the finding was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * An error message.
     */
    val error: String? = builder.error
    /**
     * Indicates whether the policy that generated the finding grants public access to the
     * resource.
     */
    val isPublic: Boolean? = builder.isPublic
    /**
     * The ARN of the resource that was analyzed.
     */
    val resourceArn: String? = builder.resourceArn
    /**
     * The Amazon Web Services account ID that owns the resource.
     */
    val resourceOwnerAccount: String? = builder.resourceOwnerAccount
    /**
     * The type of the resource that was analyzed.
     */
    val resourceType: ResourceType? = builder.resourceType
    /**
     * Indicates how the access that generated the finding is granted. This is populated for
     * Amazon S3 bucket findings.
     */
    val sharedVia: List<String>? = builder.sharedVia
    /**
     * The current status of the finding generated from the analyzed resource.
     */
    val status: FindingStatus? = builder.status
    /**
     * The time at which the finding was updated.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AnalyzedResource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyzedResource(")
        append("actions=$actions,")
        append("analyzedAt=$analyzedAt,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("isPublic=$isPublic,")
        append("resourceArn=$resourceArn,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("sharedVia=$sharedVia,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (analyzedAt?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (isPublic?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerAccount?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sharedVia?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AnalyzedResource

        if (actions != other.actions) return false
        if (analyzedAt != other.analyzedAt) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (isPublic != other.isPublic) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (sharedVia != other.sharedVia) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AnalyzedResource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AnalyzedResource
        /**
         * The actions that an external principal is granted permission to use by the policy that
         * generated the finding.
         */
        fun actions(actions: List<String>): FluentBuilder
        /**
         * The time at which the resource was analyzed.
         */
        fun analyzedAt(analyzedAt: Instant): FluentBuilder
        /**
         * The time at which the finding was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * An error message.
         */
        fun error(error: String): FluentBuilder
        /**
         * Indicates whether the policy that generated the finding grants public access to the
         * resource.
         */
        fun isPublic(isPublic: Boolean): FluentBuilder
        /**
         * The ARN of the resource that was analyzed.
         */
        fun resourceArn(resourceArn: String): FluentBuilder
        /**
         * The Amazon Web Services account ID that owns the resource.
         */
        fun resourceOwnerAccount(resourceOwnerAccount: String): FluentBuilder
        /**
         * The type of the resource that was analyzed.
         */
        fun resourceType(resourceType: ResourceType): FluentBuilder
        /**
         * Indicates how the access that generated the finding is granted. This is populated for
         * Amazon S3 bucket findings.
         */
        fun sharedVia(sharedVia: List<String>): FluentBuilder
        /**
         * The current status of the finding generated from the analyzed resource.
         */
        fun status(status: FindingStatus): FluentBuilder
        /**
         * The time at which the finding was updated.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The actions that an external principal is granted permission to use by the policy that
         * generated the finding.
         */
        var actions: List<String>?
        /**
         * The time at which the resource was analyzed.
         */
        var analyzedAt: Instant?
        /**
         * The time at which the finding was created.
         */
        var createdAt: Instant?
        /**
         * An error message.
         */
        var error: String?
        /**
         * Indicates whether the policy that generated the finding grants public access to the
         * resource.
         */
        var isPublic: Boolean?
        /**
         * The ARN of the resource that was analyzed.
         */
        var resourceArn: String?
        /**
         * The Amazon Web Services account ID that owns the resource.
         */
        var resourceOwnerAccount: String?
        /**
         * The type of the resource that was analyzed.
         */
        var resourceType: ResourceType?
        /**
         * Indicates how the access that generated the finding is granted. This is populated for
         * Amazon S3 bucket findings.
         */
        var sharedVia: List<String>?
        /**
         * The current status of the finding generated from the analyzed resource.
         */
        var status: FindingStatus?
        /**
         * The time at which the finding was updated.
         */
        var updatedAt: Instant?

        fun build(): AnalyzedResource
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actions: List<String>? = null
        override var analyzedAt: Instant? = null
        override var createdAt: Instant? = null
        override var error: String? = null
        override var isPublic: Boolean? = null
        override var resourceArn: String? = null
        override var resourceOwnerAccount: String? = null
        override var resourceType: ResourceType? = null
        override var sharedVia: List<String>? = null
        override var status: FindingStatus? = null
        override var updatedAt: Instant? = null

        constructor(x: AnalyzedResource) : this() {
            this.actions = x.actions
            this.analyzedAt = x.analyzedAt
            this.createdAt = x.createdAt
            this.error = x.error
            this.isPublic = x.isPublic
            this.resourceArn = x.resourceArn
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.sharedVia = x.sharedVia
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        override fun build(): AnalyzedResource = AnalyzedResource(this)
        override fun actions(actions: List<String>): FluentBuilder = apply { this.actions = actions }
        override fun analyzedAt(analyzedAt: Instant): FluentBuilder = apply { this.analyzedAt = analyzedAt }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun error(error: String): FluentBuilder = apply { this.error = error }
        override fun isPublic(isPublic: Boolean): FluentBuilder = apply { this.isPublic = isPublic }
        override fun resourceArn(resourceArn: String): FluentBuilder = apply { this.resourceArn = resourceArn }
        override fun resourceOwnerAccount(resourceOwnerAccount: String): FluentBuilder = apply { this.resourceOwnerAccount = resourceOwnerAccount }
        override fun resourceType(resourceType: ResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun sharedVia(sharedVia: List<String>): FluentBuilder = apply { this.sharedVia = sharedVia }
        override fun status(status: FindingStatus): FluentBuilder = apply { this.status = status }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
