// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An access preview finding generated by the access preview.
 */
class AccessPreviewFinding private constructor(builder: BuilderImpl) {
    /**
     * The action in the analyzed policy statement that an external principal has permission to
     * perform.
     */
    val action: List<String>? = builder.action
    /**
     * Provides context on how the access preview finding compares to existing access
     * identified in IAM Access Analyzer.
     * New - The finding is for newly-introduced access.
     * Unchanged - The preview finding is an existing finding that would
     * remain unchanged.
     * Changed - The preview finding is an existing finding with a change in
     * status.
     * For example, a Changed finding with preview status Resolved
     * and existing status Active indicates the existing Active finding
     * would become Resolved as a result of the proposed permissions change.
     */
    val changeType: FindingChangeType? = builder.changeType
    /**
     * The condition in the analyzed policy statement that resulted in a finding.
     */
    val condition: Map<String, String>? = builder.condition
    /**
     * The time at which the access preview finding was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * An error.
     */
    val error: String? = builder.error
    /**
     * The existing ID of the finding in IAM Access Analyzer, provided only for existing
     * findings.
     */
    val existingFindingId: String? = builder.existingFindingId
    /**
     * The existing status of the finding, provided only for existing findings.
     */
    val existingFindingStatus: FindingStatus? = builder.existingFindingStatus
    /**
     * The ID of the access preview finding. This ID uniquely identifies the element in the
     * list of access preview findings and is not related to the finding ID in Access
     * Analyzer.
     */
    val id: String? = builder.id
    /**
     * Indicates whether the policy that generated the finding allows public access to the
     * resource.
     */
    val isPublic: Boolean? = builder.isPublic
    /**
     * The external principal that has access to a resource within the zone of trust.
     */
    val principal: Map<String, String>? = builder.principal
    /**
     * The resource that an external principal has access to. This is the resource associated
     * with the access preview.
     */
    val resource: String? = builder.resource
    /**
     * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
     * account is the account in which the resource was created.
     */
    val resourceOwnerAccount: String? = builder.resourceOwnerAccount
    /**
     * The type of the resource that can be accessed in the finding.
     */
    val resourceType: ResourceType? = builder.resourceType
    /**
     * The sources of the finding. This indicates how the access that generated the finding is
     * granted. It is populated for Amazon S3 bucket findings.
     */
    val sources: List<FindingSource>? = builder.sources
    /**
     * The preview status of the finding. This is what the status of the finding would be after
     * permissions deployment. For example, a Changed finding with preview status
     * Resolved and existing status Active indicates the existing
     * Active finding would become Resolved as a result of the
     * proposed permissions change.
     */
    val status: FindingStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AccessPreviewFinding = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPreviewFinding(")
        append("action=$action,")
        append("changeType=$changeType,")
        append("condition=$condition,")
        append("createdAt=$createdAt,")
        append("error=$error,")
        append("existingFindingId=$existingFindingId,")
        append("existingFindingStatus=$existingFindingStatus,")
        append("id=$id,")
        append("isPublic=$isPublic,")
        append("principal=$principal,")
        append("resource=$resource,")
        append("resourceOwnerAccount=$resourceOwnerAccount,")
        append("resourceType=$resourceType,")
        append("sources=$sources,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (changeType?.hashCode() ?: 0)
        result = 31 * result + (condition?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (existingFindingId?.hashCode() ?: 0)
        result = 31 * result + (existingFindingStatus?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isPublic?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerAccount?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccessPreviewFinding

        if (action != other.action) return false
        if (changeType != other.changeType) return false
        if (condition != other.condition) return false
        if (createdAt != other.createdAt) return false
        if (error != other.error) return false
        if (existingFindingId != other.existingFindingId) return false
        if (existingFindingStatus != other.existingFindingStatus) return false
        if (id != other.id) return false
        if (isPublic != other.isPublic) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false
        if (resourceType != other.resourceType) return false
        if (sources != other.sources) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AccessPreviewFinding = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AccessPreviewFinding
        /**
         * The action in the analyzed policy statement that an external principal has permission to
         * perform.
         */
        fun action(action: List<String>): FluentBuilder
        /**
         * Provides context on how the access preview finding compares to existing access
         * identified in IAM Access Analyzer.
         * New - The finding is for newly-introduced access.
         * Unchanged - The preview finding is an existing finding that would
         * remain unchanged.
         * Changed - The preview finding is an existing finding with a change in
         * status.
         * For example, a Changed finding with preview status Resolved
         * and existing status Active indicates the existing Active finding
         * would become Resolved as a result of the proposed permissions change.
         */
        fun changeType(changeType: FindingChangeType): FluentBuilder
        /**
         * The condition in the analyzed policy statement that resulted in a finding.
         */
        fun condition(condition: Map<String, String>): FluentBuilder
        /**
         * The time at which the access preview finding was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * An error.
         */
        fun error(error: String): FluentBuilder
        /**
         * The existing ID of the finding in IAM Access Analyzer, provided only for existing
         * findings.
         */
        fun existingFindingId(existingFindingId: String): FluentBuilder
        /**
         * The existing status of the finding, provided only for existing findings.
         */
        fun existingFindingStatus(existingFindingStatus: FindingStatus): FluentBuilder
        /**
         * The ID of the access preview finding. This ID uniquely identifies the element in the
         * list of access preview findings and is not related to the finding ID in Access
         * Analyzer.
         */
        fun id(id: String): FluentBuilder
        /**
         * Indicates whether the policy that generated the finding allows public access to the
         * resource.
         */
        fun isPublic(isPublic: Boolean): FluentBuilder
        /**
         * The external principal that has access to a resource within the zone of trust.
         */
        fun principal(principal: Map<String, String>): FluentBuilder
        /**
         * The resource that an external principal has access to. This is the resource associated
         * with the access preview.
         */
        fun resource(resource: String): FluentBuilder
        /**
         * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
         * account is the account in which the resource was created.
         */
        fun resourceOwnerAccount(resourceOwnerAccount: String): FluentBuilder
        /**
         * The type of the resource that can be accessed in the finding.
         */
        fun resourceType(resourceType: ResourceType): FluentBuilder
        /**
         * The sources of the finding. This indicates how the access that generated the finding is
         * granted. It is populated for Amazon S3 bucket findings.
         */
        fun sources(sources: List<FindingSource>): FluentBuilder
        /**
         * The preview status of the finding. This is what the status of the finding would be after
         * permissions deployment. For example, a Changed finding with preview status
         * Resolved and existing status Active indicates the existing
         * Active finding would become Resolved as a result of the
         * proposed permissions change.
         */
        fun status(status: FindingStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action in the analyzed policy statement that an external principal has permission to
         * perform.
         */
        var action: List<String>?
        /**
         * Provides context on how the access preview finding compares to existing access
         * identified in IAM Access Analyzer.
         * New - The finding is for newly-introduced access.
         * Unchanged - The preview finding is an existing finding that would
         * remain unchanged.
         * Changed - The preview finding is an existing finding with a change in
         * status.
         * For example, a Changed finding with preview status Resolved
         * and existing status Active indicates the existing Active finding
         * would become Resolved as a result of the proposed permissions change.
         */
        var changeType: FindingChangeType?
        /**
         * The condition in the analyzed policy statement that resulted in a finding.
         */
        var condition: Map<String, String>?
        /**
         * The time at which the access preview finding was created.
         */
        var createdAt: Instant?
        /**
         * An error.
         */
        var error: String?
        /**
         * The existing ID of the finding in IAM Access Analyzer, provided only for existing
         * findings.
         */
        var existingFindingId: String?
        /**
         * The existing status of the finding, provided only for existing findings.
         */
        var existingFindingStatus: FindingStatus?
        /**
         * The ID of the access preview finding. This ID uniquely identifies the element in the
         * list of access preview findings and is not related to the finding ID in Access
         * Analyzer.
         */
        var id: String?
        /**
         * Indicates whether the policy that generated the finding allows public access to the
         * resource.
         */
        var isPublic: Boolean?
        /**
         * The external principal that has access to a resource within the zone of trust.
         */
        var principal: Map<String, String>?
        /**
         * The resource that an external principal has access to. This is the resource associated
         * with the access preview.
         */
        var resource: String?
        /**
         * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning
         * account is the account in which the resource was created.
         */
        var resourceOwnerAccount: String?
        /**
         * The type of the resource that can be accessed in the finding.
         */
        var resourceType: ResourceType?
        /**
         * The sources of the finding. This indicates how the access that generated the finding is
         * granted. It is populated for Amazon S3 bucket findings.
         */
        var sources: List<FindingSource>?
        /**
         * The preview status of the finding. This is what the status of the finding would be after
         * permissions deployment. For example, a Changed finding with preview status
         * Resolved and existing status Active indicates the existing
         * Active finding would become Resolved as a result of the
         * proposed permissions change.
         */
        var status: FindingStatus?

        fun build(): AccessPreviewFinding
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: List<String>? = null
        override var changeType: FindingChangeType? = null
        override var condition: Map<String, String>? = null
        override var createdAt: Instant? = null
        override var error: String? = null
        override var existingFindingId: String? = null
        override var existingFindingStatus: FindingStatus? = null
        override var id: String? = null
        override var isPublic: Boolean? = null
        override var principal: Map<String, String>? = null
        override var resource: String? = null
        override var resourceOwnerAccount: String? = null
        override var resourceType: ResourceType? = null
        override var sources: List<FindingSource>? = null
        override var status: FindingStatus? = null

        constructor(x: AccessPreviewFinding) : this() {
            this.action = x.action
            this.changeType = x.changeType
            this.condition = x.condition
            this.createdAt = x.createdAt
            this.error = x.error
            this.existingFindingId = x.existingFindingId
            this.existingFindingStatus = x.existingFindingStatus
            this.id = x.id
            this.isPublic = x.isPublic
            this.principal = x.principal
            this.resource = x.resource
            this.resourceOwnerAccount = x.resourceOwnerAccount
            this.resourceType = x.resourceType
            this.sources = x.sources
            this.status = x.status
        }

        override fun build(): AccessPreviewFinding = AccessPreviewFinding(this)
        override fun action(action: List<String>): FluentBuilder = apply { this.action = action }
        override fun changeType(changeType: FindingChangeType): FluentBuilder = apply { this.changeType = changeType }
        override fun condition(condition: Map<String, String>): FluentBuilder = apply { this.condition = condition }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun error(error: String): FluentBuilder = apply { this.error = error }
        override fun existingFindingId(existingFindingId: String): FluentBuilder = apply { this.existingFindingId = existingFindingId }
        override fun existingFindingStatus(existingFindingStatus: FindingStatus): FluentBuilder = apply { this.existingFindingStatus = existingFindingStatus }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun isPublic(isPublic: Boolean): FluentBuilder = apply { this.isPublic = isPublic }
        override fun principal(principal: Map<String, String>): FluentBuilder = apply { this.principal = principal }
        override fun resource(resource: String): FluentBuilder = apply { this.resource = resource }
        override fun resourceOwnerAccount(resourceOwnerAccount: String): FluentBuilder = apply { this.resourceOwnerAccount = resourceOwnerAccount }
        override fun resourceType(resourceType: ResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun sources(sources: List<FindingSource>): FluentBuilder = apply { this.sources = sources }
        override fun status(status: FindingStatus): FluentBuilder = apply { this.status = status }
    }
}
