// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an access preview.
 */
class AccessPreview private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the analyzer used to generate the access preview.
     */
    val analyzerArn: String? = builder.analyzerArn
    /**
     * A map of resource ARNs for the proposed resource configuration.
     */
    val configurations: Map<String, Configuration>? = builder.configurations
    /**
     * The time at which the access preview was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The unique ID for the access preview.
     */
    val id: String? = builder.id
    /**
     * The status of the access preview.
     * Creating - The access preview creation is in progress.
     * Completed - The access preview is complete. You can preview findings
     * for external access to the resource.
     * Failed - The access preview creation has failed.
     */
    val status: AccessPreviewStatus? = builder.status
    /**
     * Provides more details about the current status of the access preview.
     * For example, if the creation of the access preview fails, a Failed status
     * is returned. This failure can be due to an internal issue with the analysis or due to an
     * invalid resource configuration.
     */
    val statusReason: AccessPreviewStatusReason? = builder.statusReason

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AccessPreview = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPreview(")
        append("analyzerArn=$analyzerArn,")
        append("configurations=$configurations,")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("status=$status,")
        append("statusReason=$statusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn?.hashCode() ?: 0
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccessPreview

        if (analyzerArn != other.analyzerArn) return false
        if (configurations != other.configurations) return false
        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AccessPreview = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AccessPreview
        /**
         * The ARN of the analyzer used to generate the access preview.
         */
        fun analyzerArn(analyzerArn: String): FluentBuilder
        /**
         * A map of resource ARNs for the proposed resource configuration.
         */
        fun configurations(configurations: Map<String, Configuration>): FluentBuilder
        /**
         * The time at which the access preview was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The unique ID for the access preview.
         */
        fun id(id: String): FluentBuilder
        /**
         * The status of the access preview.
         * Creating - The access preview creation is in progress.
         * Completed - The access preview is complete. You can preview findings
         * for external access to the resource.
         * Failed - The access preview creation has failed.
         */
        fun status(status: AccessPreviewStatus): FluentBuilder
        /**
         * Provides more details about the current status of the access preview.
         * For example, if the creation of the access preview fails, a Failed status
         * is returned. This failure can be due to an internal issue with the analysis or due to an
         * invalid resource configuration.
         */
        fun statusReason(statusReason: AccessPreviewStatusReason): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the analyzer used to generate the access preview.
         */
        var analyzerArn: String?
        /**
         * A map of resource ARNs for the proposed resource configuration.
         */
        var configurations: Map<String, Configuration>?
        /**
         * The time at which the access preview was created.
         */
        var createdAt: Instant?
        /**
         * The unique ID for the access preview.
         */
        var id: String?
        /**
         * The status of the access preview.
         * Creating - The access preview creation is in progress.
         * Completed - The access preview is complete. You can preview findings
         * for external access to the resource.
         * Failed - The access preview creation has failed.
         */
        var status: AccessPreviewStatus?
        /**
         * Provides more details about the current status of the access preview.
         * For example, if the creation of the access preview fails, a Failed status
         * is returned. This failure can be due to an internal issue with the analysis or due to an
         * invalid resource configuration.
         */
        var statusReason: AccessPreviewStatusReason?

        fun build(): AccessPreview
        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewStatusReason] inside the given [block]
         */
        fun statusReason(block: AccessPreviewStatusReason.DslBuilder.() -> kotlin.Unit) {
            this.statusReason = AccessPreviewStatusReason.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var analyzerArn: String? = null
        override var configurations: Map<String, Configuration>? = null
        override var createdAt: Instant? = null
        override var id: String? = null
        override var status: AccessPreviewStatus? = null
        override var statusReason: AccessPreviewStatusReason? = null

        constructor(x: AccessPreview) : this() {
            this.analyzerArn = x.analyzerArn
            this.configurations = x.configurations
            this.createdAt = x.createdAt
            this.id = x.id
            this.status = x.status
            this.statusReason = x.statusReason
        }

        override fun build(): AccessPreview = AccessPreview(this)
        override fun analyzerArn(analyzerArn: String): FluentBuilder = apply { this.analyzerArn = analyzerArn }
        override fun configurations(configurations: Map<String, Configuration>): FluentBuilder = apply { this.configurations = configurations }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun status(status: AccessPreviewStatus): FluentBuilder = apply { this.status = status }
        override fun statusReason(statusReason: AccessPreviewStatusReason): FluentBuilder = apply { this.statusReason = statusReason }
    }
}
