// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.accessanalyzer.model.*
import aws.sdk.kotlin.services.accessanalyzer.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "AccessAnalyzer"
const val ServiceApiVersion: String = "2019-11-01"
const val SdkVersion: String = "0.8.0-alpha"

internal class DefaultAccessAnalyzerClient(override val config: AccessAnalyzerClient.Config) : AccessAnalyzerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Retroactively applies the archive rule to existing findings that meet the archive rule
     * criteria.
     */
    override suspend fun applyArchiveRule(input: ApplyArchiveRuleRequest): ApplyArchiveRuleResponse {
        val op = SdkHttpOperation.build<ApplyArchiveRuleRequest, ApplyArchiveRuleResponse> {
            serializer = ApplyArchiveRuleOperationSerializer()
            deserializer = ApplyArchiveRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApplyArchiveRule"
            }
        }
        registerApplyArchiveRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the requested policy generation.
     */
    override suspend fun cancelPolicyGeneration(input: CancelPolicyGenerationRequest): CancelPolicyGenerationResponse {
        val op = SdkHttpOperation.build<CancelPolicyGenerationRequest, CancelPolicyGenerationResponse> {
            serializer = CancelPolicyGenerationOperationSerializer()
            deserializer = CancelPolicyGenerationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelPolicyGeneration"
            }
        }
        registerCancelPolicyGenerationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an access preview that allows you to preview IAM Access Analyzer findings for your
     * resource before deploying resource permissions.
     */
    override suspend fun createAccessPreview(input: CreateAccessPreviewRequest): CreateAccessPreviewResponse {
        val op = SdkHttpOperation.build<CreateAccessPreviewRequest, CreateAccessPreviewResponse> {
            serializer = CreateAccessPreviewOperationSerializer()
            deserializer = CreateAccessPreviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAccessPreview"
            }
        }
        registerCreateAccessPreviewMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an analyzer for your account.
     */
    override suspend fun createAnalyzer(input: CreateAnalyzerRequest): CreateAnalyzerResponse {
        val op = SdkHttpOperation.build<CreateAnalyzerRequest, CreateAnalyzerResponse> {
            serializer = CreateAnalyzerOperationSerializer()
            deserializer = CreateAnalyzerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAnalyzer"
            }
        }
        registerCreateAnalyzerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an archive rule for the specified analyzer. Archive rules automatically archive
     * new findings that meet the criteria you define when you create the rule.
     * To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    override suspend fun createArchiveRule(input: CreateArchiveRuleRequest): CreateArchiveRuleResponse {
        val op = SdkHttpOperation.build<CreateArchiveRuleRequest, CreateArchiveRuleResponse> {
            serializer = CreateArchiveRuleOperationSerializer()
            deserializer = CreateArchiveRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateArchiveRule"
            }
        }
        registerCreateArchiveRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled
     * for the account or organization in the current or specific Region. All findings that were
     * generated by the analyzer are deleted. You cannot undo this action.
     */
    override suspend fun deleteAnalyzer(input: DeleteAnalyzerRequest): DeleteAnalyzerResponse {
        val op = SdkHttpOperation.build<DeleteAnalyzerRequest, DeleteAnalyzerResponse> {
            serializer = DeleteAnalyzerOperationSerializer()
            deserializer = DeleteAnalyzerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAnalyzer"
            }
        }
        registerDeleteAnalyzerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified archive rule.
     */
    override suspend fun deleteArchiveRule(input: DeleteArchiveRuleRequest): DeleteArchiveRuleResponse {
        val op = SdkHttpOperation.build<DeleteArchiveRuleRequest, DeleteArchiveRuleResponse> {
            serializer = DeleteArchiveRuleOperationSerializer()
            deserializer = DeleteArchiveRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteArchiveRule"
            }
        }
        registerDeleteArchiveRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an access preview for the specified analyzer.
     */
    override suspend fun getAccessPreview(input: GetAccessPreviewRequest): GetAccessPreviewResponse {
        val op = SdkHttpOperation.build<GetAccessPreviewRequest, GetAccessPreviewResponse> {
            serializer = GetAccessPreviewOperationSerializer()
            deserializer = GetAccessPreviewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccessPreview"
            }
        }
        registerGetAccessPreviewMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a resource that was analyzed.
     */
    override suspend fun getAnalyzedResource(input: GetAnalyzedResourceRequest): GetAnalyzedResourceResponse {
        val op = SdkHttpOperation.build<GetAnalyzedResourceRequest, GetAnalyzedResourceResponse> {
            serializer = GetAnalyzedResourceOperationSerializer()
            deserializer = GetAnalyzedResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAnalyzedResource"
            }
        }
        registerGetAnalyzedResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the specified analyzer.
     */
    override suspend fun getAnalyzer(input: GetAnalyzerRequest): GetAnalyzerResponse {
        val op = SdkHttpOperation.build<GetAnalyzerRequest, GetAnalyzerResponse> {
            serializer = GetAnalyzerOperationSerializer()
            deserializer = GetAnalyzerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAnalyzer"
            }
        }
        registerGetAnalyzerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an archive rule.
     * To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    override suspend fun getArchiveRule(input: GetArchiveRuleRequest): GetArchiveRuleResponse {
        val op = SdkHttpOperation.build<GetArchiveRuleRequest, GetArchiveRuleResponse> {
            serializer = GetArchiveRuleOperationSerializer()
            deserializer = GetArchiveRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetArchiveRule"
            }
        }
        registerGetArchiveRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the specified finding.
     */
    override suspend fun getFinding(input: GetFindingRequest): GetFindingResponse {
        val op = SdkHttpOperation.build<GetFindingRequest, GetFindingResponse> {
            serializer = GetFindingOperationSerializer()
            deserializer = GetFindingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFinding"
            }
        }
        registerGetFindingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the policy that was generated using StartPolicyGeneration.
     */
    override suspend fun getGeneratedPolicy(input: GetGeneratedPolicyRequest): GetGeneratedPolicyResponse {
        val op = SdkHttpOperation.build<GetGeneratedPolicyRequest, GetGeneratedPolicyResponse> {
            serializer = GetGeneratedPolicyOperationSerializer()
            deserializer = GetGeneratedPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGeneratedPolicy"
            }
        }
        registerGetGeneratedPolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of access preview findings generated by the specified access
     * preview.
     */
    override suspend fun listAccessPreviewFindings(input: ListAccessPreviewFindingsRequest): ListAccessPreviewFindingsResponse {
        val op = SdkHttpOperation.build<ListAccessPreviewFindingsRequest, ListAccessPreviewFindingsResponse> {
            serializer = ListAccessPreviewFindingsOperationSerializer()
            deserializer = ListAccessPreviewFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccessPreviewFindings"
            }
        }
        registerListAccessPreviewFindingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of access previews for the specified analyzer.
     */
    override suspend fun listAccessPreviews(input: ListAccessPreviewsRequest): ListAccessPreviewsResponse {
        val op = SdkHttpOperation.build<ListAccessPreviewsRequest, ListAccessPreviewsResponse> {
            serializer = ListAccessPreviewsOperationSerializer()
            deserializer = ListAccessPreviewsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccessPreviews"
            }
        }
        registerListAccessPreviewsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of resources of the specified type that have been analyzed by the
     * specified analyzer..
     */
    override suspend fun listAnalyzedResources(input: ListAnalyzedResourcesRequest): ListAnalyzedResourcesResponse {
        val op = SdkHttpOperation.build<ListAnalyzedResourcesRequest, ListAnalyzedResourcesResponse> {
            serializer = ListAnalyzedResourcesOperationSerializer()
            deserializer = ListAnalyzedResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAnalyzedResources"
            }
        }
        registerListAnalyzedResourcesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of analyzers.
     */
    override suspend fun listAnalyzers(input: ListAnalyzersRequest): ListAnalyzersResponse {
        val op = SdkHttpOperation.build<ListAnalyzersRequest, ListAnalyzersResponse> {
            serializer = ListAnalyzersOperationSerializer()
            deserializer = ListAnalyzersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAnalyzers"
            }
        }
        registerListAnalyzersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of archive rules created for the specified analyzer.
     */
    override suspend fun listArchiveRules(input: ListArchiveRulesRequest): ListArchiveRulesResponse {
        val op = SdkHttpOperation.build<ListArchiveRulesRequest, ListArchiveRulesResponse> {
            serializer = ListArchiveRulesOperationSerializer()
            deserializer = ListArchiveRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListArchiveRules"
            }
        }
        registerListArchiveRulesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of findings generated by the specified analyzer.
     * To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    override suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse {
        val op = SdkHttpOperation.build<ListFindingsRequest, ListFindingsResponse> {
            serializer = ListFindingsOperationSerializer()
            deserializer = ListFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindings"
            }
        }
        registerListFindingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the policy generations requested in the last seven days.
     */
    override suspend fun listPolicyGenerations(input: ListPolicyGenerationsRequest): ListPolicyGenerationsResponse {
        val op = SdkHttpOperation.build<ListPolicyGenerationsRequest, ListPolicyGenerationsResponse> {
            serializer = ListPolicyGenerationsOperationSerializer()
            deserializer = ListPolicyGenerationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPolicyGenerations"
            }
        }
        registerListPolicyGenerationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of tags applied to the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the policy generation request.
     */
    override suspend fun startPolicyGeneration(input: StartPolicyGenerationRequest): StartPolicyGenerationResponse {
        val op = SdkHttpOperation.build<StartPolicyGenerationRequest, StartPolicyGenerationResponse> {
            serializer = StartPolicyGenerationOperationSerializer()
            deserializer = StartPolicyGenerationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartPolicyGeneration"
            }
        }
        registerStartPolicyGenerationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Immediately starts a scan of the policies applied to the specified resource.
     */
    override suspend fun startResourceScan(input: StartResourceScanRequest): StartResourceScanResponse {
        val op = SdkHttpOperation.build<StartResourceScanRequest, StartResourceScanResponse> {
            serializer = StartResourceScanOperationSerializer()
            deserializer = StartResourceScanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartResourceScan"
            }
        }
        registerStartResourceScanMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a tag to the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the criteria and values for the specified archive rule.
     */
    override suspend fun updateArchiveRule(input: UpdateArchiveRuleRequest): UpdateArchiveRuleResponse {
        val op = SdkHttpOperation.build<UpdateArchiveRuleRequest, UpdateArchiveRuleResponse> {
            serializer = UpdateArchiveRuleOperationSerializer()
            deserializer = UpdateArchiveRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateArchiveRule"
            }
        }
        registerUpdateArchiveRuleMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status for the specified findings.
     */
    override suspend fun updateFindings(input: UpdateFindingsRequest): UpdateFindingsResponse {
        val op = SdkHttpOperation.build<UpdateFindingsRequest, UpdateFindingsResponse> {
            serializer = UpdateFindingsOperationSerializer()
            deserializer = UpdateFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFindings"
            }
        }
        registerUpdateFindingsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Requests the validation of a policy and returns a list of findings. The findings help
     * you identify issues and provide actionable recommendations to resolve the issue and enable
     * you to author functional policies that meet security best practices.
     */
    override suspend fun validatePolicy(input: ValidatePolicyRequest): ValidatePolicyResponse {
        val op = SdkHttpOperation.build<ValidatePolicyRequest, ValidatePolicyResponse> {
            serializer = ValidatePolicyOperationSerializer()
            deserializer = ValidatePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ValidatePolicy"
            }
        }
        registerValidatePolicyMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
