// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.services.accessanalyzer.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.accessanalyzer.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Identity and Access Management Access Analyzer helps identify potential resource-access risks by enabling you to
 * identify any policies that grant access to an external principal. It does this by using
 * logic-based reasoning to analyze resource-based policies in your Amazon Web Services environment. An
 * external principal can be another Amazon Web Services account, a root user, an IAM user or role, a
 * federated user, an Amazon Web Services service, or an anonymous user. You can also use IAM Access Analyzer to
 * preview and validate public and cross-account access to your resources before deploying
 * permissions changes. This guide describes the Identity and Access Management Access Analyzer operations that you can
 * call programmatically. For general information about IAM Access Analyzer, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html">Identity and Access Management Access Analyzer in the IAM User Guide.
 * To start using IAM Access Analyzer, you first need to create an analyzer.
 */
interface AccessAnalyzerClient : SdkClient {

    override val serviceName: String
        get() = "AccessAnalyzer"
    /**
     * AccessAnalyzerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): AccessAnalyzerClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultAccessAnalyzerClient(config)
        }

        operator fun invoke(config: Config): AccessAnalyzerClient = DefaultAccessAnalyzerClient(config)

        /**
         * Construct a [AccessAnalyzerClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): AccessAnalyzerClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return AccessAnalyzerClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: EndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Retroactively applies the archive rule to existing findings that meet the archive rule
     * criteria.
     */
    suspend fun applyArchiveRule(input: ApplyArchiveRuleRequest): ApplyArchiveRuleResponse

    /**
     * Retroactively applies the archive rule to existing findings that meet the archive rule
     * criteria.
     */
    suspend fun applyArchiveRule(block: ApplyArchiveRuleRequest.DslBuilder.() -> Unit) = applyArchiveRule(ApplyArchiveRuleRequest.builder().apply(block).build())

    /**
     * Cancels the requested policy generation.
     */
    suspend fun cancelPolicyGeneration(input: CancelPolicyGenerationRequest): CancelPolicyGenerationResponse

    /**
     * Cancels the requested policy generation.
     */
    suspend fun cancelPolicyGeneration(block: CancelPolicyGenerationRequest.DslBuilder.() -> Unit) = cancelPolicyGeneration(CancelPolicyGenerationRequest.builder().apply(block).build())

    /**
     * Creates an access preview that allows you to preview IAM Access Analyzer findings for your
     * resource before deploying resource permissions.
     */
    suspend fun createAccessPreview(input: CreateAccessPreviewRequest): CreateAccessPreviewResponse

    /**
     * Creates an access preview that allows you to preview IAM Access Analyzer findings for your
     * resource before deploying resource permissions.
     */
    suspend fun createAccessPreview(block: CreateAccessPreviewRequest.DslBuilder.() -> Unit) = createAccessPreview(CreateAccessPreviewRequest.builder().apply(block).build())

    /**
     * Creates an analyzer for your account.
     */
    suspend fun createAnalyzer(input: CreateAnalyzerRequest): CreateAnalyzerResponse

    /**
     * Creates an analyzer for your account.
     */
    suspend fun createAnalyzer(block: CreateAnalyzerRequest.DslBuilder.() -> Unit) = createAnalyzer(CreateAnalyzerRequest.builder().apply(block).build())

    /**
     * Creates an archive rule for the specified analyzer. Archive rules automatically archive
     * new findings that meet the criteria you define when you create the rule.
     * To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    suspend fun createArchiveRule(input: CreateArchiveRuleRequest): CreateArchiveRuleResponse

    /**
     * Creates an archive rule for the specified analyzer. Archive rules automatically archive
     * new findings that meet the criteria you define when you create the rule.
     * To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    suspend fun createArchiveRule(block: CreateArchiveRuleRequest.DslBuilder.() -> Unit) = createArchiveRule(CreateArchiveRuleRequest.builder().apply(block).build())

    /**
     * Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled
     * for the account or organization in the current or specific Region. All findings that were
     * generated by the analyzer are deleted. You cannot undo this action.
     */
    suspend fun deleteAnalyzer(input: DeleteAnalyzerRequest): DeleteAnalyzerResponse

    /**
     * Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled
     * for the account or organization in the current or specific Region. All findings that were
     * generated by the analyzer are deleted. You cannot undo this action.
     */
    suspend fun deleteAnalyzer(block: DeleteAnalyzerRequest.DslBuilder.() -> Unit) = deleteAnalyzer(DeleteAnalyzerRequest.builder().apply(block).build())

    /**
     * Deletes the specified archive rule.
     */
    suspend fun deleteArchiveRule(input: DeleteArchiveRuleRequest): DeleteArchiveRuleResponse

    /**
     * Deletes the specified archive rule.
     */
    suspend fun deleteArchiveRule(block: DeleteArchiveRuleRequest.DslBuilder.() -> Unit) = deleteArchiveRule(DeleteArchiveRuleRequest.builder().apply(block).build())

    /**
     * Retrieves information about an access preview for the specified analyzer.
     */
    suspend fun getAccessPreview(input: GetAccessPreviewRequest): GetAccessPreviewResponse

    /**
     * Retrieves information about an access preview for the specified analyzer.
     */
    suspend fun getAccessPreview(block: GetAccessPreviewRequest.DslBuilder.() -> Unit) = getAccessPreview(GetAccessPreviewRequest.builder().apply(block).build())

    /**
     * Retrieves information about a resource that was analyzed.
     */
    suspend fun getAnalyzedResource(input: GetAnalyzedResourceRequest): GetAnalyzedResourceResponse

    /**
     * Retrieves information about a resource that was analyzed.
     */
    suspend fun getAnalyzedResource(block: GetAnalyzedResourceRequest.DslBuilder.() -> Unit) = getAnalyzedResource(GetAnalyzedResourceRequest.builder().apply(block).build())

    /**
     * Retrieves information about the specified analyzer.
     */
    suspend fun getAnalyzer(input: GetAnalyzerRequest): GetAnalyzerResponse

    /**
     * Retrieves information about the specified analyzer.
     */
    suspend fun getAnalyzer(block: GetAnalyzerRequest.DslBuilder.() -> Unit) = getAnalyzer(GetAnalyzerRequest.builder().apply(block).build())

    /**
     * Retrieves information about an archive rule.
     * To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    suspend fun getArchiveRule(input: GetArchiveRuleRequest): GetArchiveRuleResponse

    /**
     * Retrieves information about an archive rule.
     * To learn about filter keys that you can use to create an archive rule, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    suspend fun getArchiveRule(block: GetArchiveRuleRequest.DslBuilder.() -> Unit) = getArchiveRule(GetArchiveRuleRequest.builder().apply(block).build())

    /**
     * Retrieves information about the specified finding.
     */
    suspend fun getFinding(input: GetFindingRequest): GetFindingResponse

    /**
     * Retrieves information about the specified finding.
     */
    suspend fun getFinding(block: GetFindingRequest.DslBuilder.() -> Unit) = getFinding(GetFindingRequest.builder().apply(block).build())

    /**
     * Retrieves the policy that was generated using StartPolicyGeneration.
     */
    suspend fun getGeneratedPolicy(input: GetGeneratedPolicyRequest): GetGeneratedPolicyResponse

    /**
     * Retrieves the policy that was generated using StartPolicyGeneration.
     */
    suspend fun getGeneratedPolicy(block: GetGeneratedPolicyRequest.DslBuilder.() -> Unit) = getGeneratedPolicy(GetGeneratedPolicyRequest.builder().apply(block).build())

    /**
     * Retrieves a list of access preview findings generated by the specified access
     * preview.
     */
    suspend fun listAccessPreviewFindings(input: ListAccessPreviewFindingsRequest): ListAccessPreviewFindingsResponse

    /**
     * Retrieves a list of access preview findings generated by the specified access
     * preview.
     */
    suspend fun listAccessPreviewFindings(block: ListAccessPreviewFindingsRequest.DslBuilder.() -> Unit) = listAccessPreviewFindings(ListAccessPreviewFindingsRequest.builder().apply(block).build())

    /**
     * Retrieves a list of access previews for the specified analyzer.
     */
    suspend fun listAccessPreviews(input: ListAccessPreviewsRequest): ListAccessPreviewsResponse

    /**
     * Retrieves a list of access previews for the specified analyzer.
     */
    suspend fun listAccessPreviews(block: ListAccessPreviewsRequest.DslBuilder.() -> Unit) = listAccessPreviews(ListAccessPreviewsRequest.builder().apply(block).build())

    /**
     * Retrieves a list of resources of the specified type that have been analyzed by the
     * specified analyzer..
     */
    suspend fun listAnalyzedResources(input: ListAnalyzedResourcesRequest): ListAnalyzedResourcesResponse

    /**
     * Retrieves a list of resources of the specified type that have been analyzed by the
     * specified analyzer..
     */
    suspend fun listAnalyzedResources(block: ListAnalyzedResourcesRequest.DslBuilder.() -> Unit) = listAnalyzedResources(ListAnalyzedResourcesRequest.builder().apply(block).build())

    /**
     * Retrieves a list of analyzers.
     */
    suspend fun listAnalyzers(input: ListAnalyzersRequest): ListAnalyzersResponse

    /**
     * Retrieves a list of analyzers.
     */
    suspend fun listAnalyzers(block: ListAnalyzersRequest.DslBuilder.() -> Unit) = listAnalyzers(ListAnalyzersRequest.builder().apply(block).build())

    /**
     * Retrieves a list of archive rules created for the specified analyzer.
     */
    suspend fun listArchiveRules(input: ListArchiveRulesRequest): ListArchiveRulesResponse

    /**
     * Retrieves a list of archive rules created for the specified analyzer.
     */
    suspend fun listArchiveRules(block: ListArchiveRulesRequest.DslBuilder.() -> Unit) = listArchiveRules(ListArchiveRulesRequest.builder().apply(block).build())

    /**
     * Retrieves a list of findings generated by the specified analyzer.
     * To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse

    /**
     * Retrieves a list of findings generated by the specified analyzer.
     * To learn about filter keys that you can use to retrieve a list of findings, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access Analyzer filter keys in the IAM User Guide.
     */
    suspend fun listFindings(block: ListFindingsRequest.DslBuilder.() -> Unit) = listFindings(ListFindingsRequest.builder().apply(block).build())

    /**
     * Lists all of the policy generations requested in the last seven days.
     */
    suspend fun listPolicyGenerations(input: ListPolicyGenerationsRequest): ListPolicyGenerationsResponse

    /**
     * Lists all of the policy generations requested in the last seven days.
     */
    suspend fun listPolicyGenerations(block: ListPolicyGenerationsRequest.DslBuilder.() -> Unit) = listPolicyGenerations(ListPolicyGenerationsRequest.builder().apply(block).build())

    /**
     * Retrieves a list of tags applied to the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of tags applied to the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Starts the policy generation request.
     */
    suspend fun startPolicyGeneration(input: StartPolicyGenerationRequest): StartPolicyGenerationResponse

    /**
     * Starts the policy generation request.
     */
    suspend fun startPolicyGeneration(block: StartPolicyGenerationRequest.DslBuilder.() -> Unit) = startPolicyGeneration(StartPolicyGenerationRequest.builder().apply(block).build())

    /**
     * Immediately starts a scan of the policies applied to the specified resource.
     */
    suspend fun startResourceScan(input: StartResourceScanRequest): StartResourceScanResponse

    /**
     * Immediately starts a scan of the policies applied to the specified resource.
     */
    suspend fun startResourceScan(block: StartResourceScanRequest.DslBuilder.() -> Unit) = startResourceScan(StartResourceScanRequest.builder().apply(block).build())

    /**
     * Adds a tag to the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds a tag to the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes a tag from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the criteria and values for the specified archive rule.
     */
    suspend fun updateArchiveRule(input: UpdateArchiveRuleRequest): UpdateArchiveRuleResponse

    /**
     * Updates the criteria and values for the specified archive rule.
     */
    suspend fun updateArchiveRule(block: UpdateArchiveRuleRequest.DslBuilder.() -> Unit) = updateArchiveRule(UpdateArchiveRuleRequest.builder().apply(block).build())

    /**
     * Updates the status for the specified findings.
     */
    suspend fun updateFindings(input: UpdateFindingsRequest): UpdateFindingsResponse

    /**
     * Updates the status for the specified findings.
     */
    suspend fun updateFindings(block: UpdateFindingsRequest.DslBuilder.() -> Unit) = updateFindings(UpdateFindingsRequest.builder().apply(block).build())

    /**
     * Requests the validation of a policy and returns a list of findings. The findings help
     * you identify issues and provide actionable recommendations to resolve the issue and enable
     * you to author functional policies that meet security best practices.
     */
    suspend fun validatePolicy(input: ValidatePolicyRequest): ValidatePolicyResponse

    /**
     * Requests the validation of a policy and returns a list of findings. The findings help
     * you identify issues and provide actionable recommendations to resolve the issue and enable
     * you to author functional policies that meet security best practices.
     */
    suspend fun validatePolicy(block: ValidatePolicyRequest.DslBuilder.() -> Unit) = validatePolicy(ValidatePolicyRequest.builder().apply(block).build())
}
