// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.serde

import aws.sdk.kotlin.services.accessanalyzer.model.AccessAnalyzerException
import aws.sdk.kotlin.services.accessanalyzer.model.GeneratedPolicyResult
import aws.sdk.kotlin.services.accessanalyzer.model.GetGeneratedPolicyResponse
import aws.sdk.kotlin.services.accessanalyzer.model.JobDetails
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetGeneratedPolicyOperationDeserializer: HttpDeserialize<GetGeneratedPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetGeneratedPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetGeneratedPolicyError(context, call)
        }
        val builder = GetGeneratedPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetGeneratedPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetGeneratedPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AccessAnalyzerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AccessAnalyzerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetGeneratedPolicyOperationBody(builder: GetGeneratedPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GENERATEDPOLICYRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("generatedPolicyResult"))
    val JOBDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jobDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GENERATEDPOLICYRESULT_DESCRIPTOR)
        field(JOBDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GENERATEDPOLICYRESULT_DESCRIPTOR.index -> builder.generatedPolicyResult = deserializeGeneratedPolicyResultDocument(deserializer)
                JOBDETAILS_DESCRIPTOR.index -> builder.jobDetails = deserializeJobDetailsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
