// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.serde

import aws.sdk.kotlin.services.accessanalyzer.model.AccessAnalyzerException
import aws.sdk.kotlin.services.accessanalyzer.model.FindingDetails
import aws.sdk.kotlin.services.accessanalyzer.model.FindingStatus
import aws.sdk.kotlin.services.accessanalyzer.model.FindingType
import aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Response
import aws.sdk.kotlin.services.accessanalyzer.model.ResourceType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetFindingV2OperationDeserializer: HttpDeserialize<GetFindingV2Response> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetFindingV2Response {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFindingV2Error(context, call)
        }
        val builder = GetFindingV2Response.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFindingV2OperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetFindingV2Error(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AccessAnalyzerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AccessAnalyzerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFindingV2OperationBody(builder: GetFindingV2Response.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANALYZEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("analyzedAt"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("error"))
    val FINDINGDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("findingDetails"))
    val FINDINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("findingType"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val RESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resource"))
    val RESOURCEOWNERACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceOwnerAccount"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceType"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANALYZEDAT_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(FINDINGDETAILS_DESCRIPTOR)
        field(FINDINGTYPE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCE_DESCRIPTOR)
        field(RESOURCEOWNERACCOUNT_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANALYZEDAT_DESCRIPTOR.index -> builder.analyzedAt = deserializeString().let { Instant.fromIso8601(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                FINDINGDETAILS_DESCRIPTOR.index -> builder.findingDetails =
                    deserializer.deserializeList(FINDINGDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<FindingDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFindingDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FINDINGTYPE_DESCRIPTOR.index -> builder.findingType = deserializeString().let { FindingType.fromValue(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESOURCE_DESCRIPTOR.index -> builder.resource = deserializeString()
                RESOURCEOWNERACCOUNT_DESCRIPTOR.index -> builder.resourceOwnerAccount = deserializeString()
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString().let { ResourceType.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { FindingStatus.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
