// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.paginators

import aws.sdk.kotlin.services.accessanalyzer.AccessAnalyzerClient
import aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewFinding
import aws.sdk.kotlin.services.accessanalyzer.model.AccessPreviewSummary
import aws.sdk.kotlin.services.accessanalyzer.model.AnalyzedResourceSummary
import aws.sdk.kotlin.services.accessanalyzer.model.FindingDetails
import aws.sdk.kotlin.services.accessanalyzer.model.FindingSummary
import aws.sdk.kotlin.services.accessanalyzer.model.FindingSummaryV2
import aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Request
import aws.sdk.kotlin.services.accessanalyzer.model.GetFindingV2Response
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewFindingsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListAccessPreviewsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListAnalyzedResourcesResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsV2Request
import aws.sdk.kotlin.services.accessanalyzer.model.ListFindingsV2Response
import aws.sdk.kotlin.services.accessanalyzer.model.ListPolicyGenerationsRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ListPolicyGenerationsResponse
import aws.sdk.kotlin.services.accessanalyzer.model.PolicyGeneration
import aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyFinding
import aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyRequest
import aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetFindingV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFindingV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingV2Response]
 */
public fun AccessAnalyzerClient.getFindingV2Paginated(initialRequest: GetFindingV2Request): Flow<GetFindingV2Response> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFindingV2Paginated.getFindingV2(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFindingV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingV2Response]
 */
public fun AccessAnalyzerClient.getFindingV2Paginated(block: GetFindingV2Request.Builder.() -> Unit): Flow<GetFindingV2Response> =
    getFindingV2Paginated(GetFindingV2Request.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getFindingV2Paginated]
 * to access the nested member [FindingDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FindingDetails]
 */
@JvmName("getFindingV2ResponseFindingDetails")
public fun Flow<GetFindingV2Response>.findingDetails(): Flow<FindingDetails> =
    transform() { response ->
        response.findingDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccessPreviewFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPreviewFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPreviewFindingsResponse]
 */
public fun AccessAnalyzerClient.listAccessPreviewFindingsPaginated(initialRequest: ListAccessPreviewFindingsRequest): Flow<ListAccessPreviewFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPreviewFindingsPaginated.listAccessPreviewFindings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPreviewFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPreviewFindingsResponse]
 */
public fun AccessAnalyzerClient.listAccessPreviewFindingsPaginated(block: ListAccessPreviewFindingsRequest.Builder.() -> Unit): Flow<ListAccessPreviewFindingsResponse> =
    listAccessPreviewFindingsPaginated(ListAccessPreviewFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessPreviewFindingsPaginated]
 * to access the nested member [AccessPreviewFinding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessPreviewFinding]
 */
@JvmName("listAccessPreviewFindingsResponseAccessPreviewFinding")
public fun Flow<ListAccessPreviewFindingsResponse>.findings(): Flow<AccessPreviewFinding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccessPreviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPreviewsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPreviewsResponse]
 */
public fun AccessAnalyzerClient.listAccessPreviewsPaginated(initialRequest: ListAccessPreviewsRequest): Flow<ListAccessPreviewsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPreviewsPaginated.listAccessPreviews(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPreviewsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPreviewsResponse]
 */
public fun AccessAnalyzerClient.listAccessPreviewsPaginated(block: ListAccessPreviewsRequest.Builder.() -> Unit): Flow<ListAccessPreviewsResponse> =
    listAccessPreviewsPaginated(ListAccessPreviewsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessPreviewsPaginated]
 * to access the nested member [AccessPreviewSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessPreviewSummary]
 */
@JvmName("listAccessPreviewsResponseAccessPreviewSummary")
public fun Flow<ListAccessPreviewsResponse>.accessPreviews(): Flow<AccessPreviewSummary> =
    transform() { response ->
        response.accessPreviews?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAnalyzedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnalyzedResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnalyzedResourcesResponse]
 */
public fun AccessAnalyzerClient.listAnalyzedResourcesPaginated(initialRequest: ListAnalyzedResourcesRequest): Flow<ListAnalyzedResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnalyzedResourcesPaginated.listAnalyzedResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAnalyzedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnalyzedResourcesResponse]
 */
public fun AccessAnalyzerClient.listAnalyzedResourcesPaginated(block: ListAnalyzedResourcesRequest.Builder.() -> Unit): Flow<ListAnalyzedResourcesResponse> =
    listAnalyzedResourcesPaginated(ListAnalyzedResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAnalyzedResourcesPaginated]
 * to access the nested member [AnalyzedResourceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AnalyzedResourceSummary]
 */
@JvmName("listAnalyzedResourcesResponseAnalyzedResourceSummary")
public fun Flow<ListAnalyzedResourcesResponse>.analyzedResources(): Flow<AnalyzedResourceSummary> =
    transform() { response ->
        response.analyzedResources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun AccessAnalyzerClient.listFindingsPaginated(initialRequest: ListFindingsRequest): Flow<ListFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsPaginated.listFindings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun AccessAnalyzerClient.listFindingsPaginated(block: ListFindingsRequest.Builder.() -> Unit): Flow<ListFindingsResponse> =
    listFindingsPaginated(ListFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingsPaginated]
 * to access the nested member [FindingSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FindingSummary]
 */
@JvmName("listFindingsResponseFindingSummary")
public fun Flow<ListFindingsResponse>.findings(): Flow<FindingSummary> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsV2Response]
 */
public fun AccessAnalyzerClient.listFindingsV2Paginated(initialRequest: ListFindingsV2Request): Flow<ListFindingsV2Response> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsV2Paginated.listFindingsV2(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsV2Response]
 */
public fun AccessAnalyzerClient.listFindingsV2Paginated(block: ListFindingsV2Request.Builder.() -> Unit): Flow<ListFindingsV2Response> =
    listFindingsV2Paginated(ListFindingsV2Request.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingsV2Paginated]
 * to access the nested member [FindingSummaryV2]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FindingSummaryV2]
 */
@JvmName("listFindingsV2ResponseFindingSummaryV2")
public fun Flow<ListFindingsV2Response>.findings(): Flow<FindingSummaryV2> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPolicyGenerationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPolicyGenerationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyGenerationsResponse]
 */
public fun AccessAnalyzerClient.listPolicyGenerationsPaginated(initialRequest: ListPolicyGenerationsRequest = ListPolicyGenerationsRequest { }): Flow<ListPolicyGenerationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPolicyGenerationsPaginated.listPolicyGenerations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPolicyGenerationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyGenerationsResponse]
 */
public fun AccessAnalyzerClient.listPolicyGenerationsPaginated(block: ListPolicyGenerationsRequest.Builder.() -> Unit): Flow<ListPolicyGenerationsResponse> =
    listPolicyGenerationsPaginated(ListPolicyGenerationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPolicyGenerationsPaginated]
 * to access the nested member [PolicyGeneration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyGeneration]
 */
@JvmName("listPolicyGenerationsResponsePolicyGeneration")
public fun Flow<ListPolicyGenerationsResponse>.policyGenerations(): Flow<PolicyGeneration> =
    transform() { response ->
        response.policyGenerations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ValidatePolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ValidatePolicyRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ValidatePolicyResponse]
 */
public fun AccessAnalyzerClient.validatePolicyPaginated(initialRequest: ValidatePolicyRequest): Flow<ValidatePolicyResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@validatePolicyPaginated.validatePolicy(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ValidatePolicyResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ValidatePolicyResponse]
 */
public fun AccessAnalyzerClient.validatePolicyPaginated(block: ValidatePolicyRequest.Builder.() -> Unit): Flow<ValidatePolicyResponse> =
    validatePolicyPaginated(ValidatePolicyRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [validatePolicyPaginated]
 * to access the nested member [ValidatePolicyFinding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ValidatePolicyFinding]
 */
@JvmName("validatePolicyResponseValidatePolicyFinding")
public fun Flow<ValidatePolicyResponse>.findings(): Flow<ValidatePolicyFinding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }
