// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



public class ValidatePolicyRequest private constructor(builder: Builder) {
    /**
     * The locale to use for localizing the findings.
     */
    public val locale: aws.sdk.kotlin.services.accessanalyzer.model.Locale? = builder.locale
    /**
     * The maximum number of results to return in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token used for pagination of results returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The JSON policy document to use as the content for the policy.
     */
    public val policyDocument: kotlin.String = requireNotNull(builder.policyDocument) { "A non-null value must be provided for policyDocument" }
    /**
     * The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups.
     *
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     *
     * Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services organization, organizational unit (OU), or an account.
     */
    public val policyType: aws.sdk.kotlin.services.accessanalyzer.model.PolicyType = requireNotNull(builder.policyType) { "A non-null value must be provided for policyType" }
    /**
     * The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is `RESOURCE_POLICY`. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose `AWS::S3::Bucket` for the policy validation resource type.
     *
     * For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.
     */
    public val validatePolicyResourceType: aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyResourceType? = builder.validatePolicyResourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidatePolicyRequest(")
        append("locale=$locale,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("policyDocument=$policyDocument,")
        append("policyType=$policyType,")
        append("validatePolicyResourceType=$validatePolicyResourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = locale?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (policyDocument.hashCode())
        result = 31 * result + (policyType.hashCode())
        result = 31 * result + (validatePolicyResourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidatePolicyRequest

        if (locale != other.locale) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (policyDocument != other.policyDocument) return false
        if (policyType != other.policyType) return false
        if (validatePolicyResourceType != other.validatePolicyResourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The locale to use for localizing the findings.
         */
        public var locale: aws.sdk.kotlin.services.accessanalyzer.model.Locale? = null
        /**
         * The maximum number of results to return in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token used for pagination of results returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The JSON policy document to use as the content for the policy.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups.
         *
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
         *
         * Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services organization, organizational unit (OU), or an account.
         */
        public var policyType: aws.sdk.kotlin.services.accessanalyzer.model.PolicyType? = null
        /**
         * The type of resource to attach to your resource policy. Specify a value for the policy validation resource type only if the policy type is `RESOURCE_POLICY`. For example, to validate a resource policy to attach to an Amazon S3 bucket, you can choose `AWS::S3::Bucket` for the policy validation resource type.
         *
         * For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource policies.
         */
        public var validatePolicyResourceType: aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyResourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyRequest) : this() {
            this.locale = x.locale
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.policyDocument = x.policyDocument
            this.policyType = x.policyType
            this.validatePolicyResourceType = x.validatePolicyResourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyRequest = ValidatePolicyRequest(this)

        internal fun correctErrors(): Builder {
            if (policyDocument == null) policyDocument = ""
            if (policyType == null) policyType = PolicyType.SdkUnknown("no value provided")
            return this
        }
    }
}
