// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * A finding in a policy. Each finding is an actionable recommendation that can be used to improve the policy.
 */
public class ValidatePolicyFinding private constructor(builder: Builder) {
    /**
     * A localized message that explains the finding and provides guidance on how to address it.
     */
    public val findingDetails: kotlin.String = requireNotNull(builder.findingDetails) { "A non-null value must be provided for findingDetails" }
    /**
     * The impact of the finding.
     *
     * Security warnings report when the policy allows access that we consider overly permissive.
     *
     * Errors report when a part of the policy is not functional.
     *
     * Warnings report non-security issues when a policy does not conform to policy writing best practices.
     *
     * Suggestions recommend stylistic improvements in the policy that do not impact access.
     */
    public val findingType: aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyFindingType = requireNotNull(builder.findingType) { "A non-null value must be provided for findingType" }
    /**
     * The issue code provides an identifier of the issue associated with this finding.
     */
    public val issueCode: kotlin.String = requireNotNull(builder.issueCode) { "A non-null value must be provided for issueCode" }
    /**
     * A link to additional documentation about the type of finding.
     */
    public val learnMoreLink: kotlin.String = requireNotNull(builder.learnMoreLink) { "A non-null value must be provided for learnMoreLink" }
    /**
     * The list of locations in the policy document that are related to the finding. The issue code provides a summary of an issue identified by the finding.
     */
    public val locations: List<Location> = requireNotNull(builder.locations) { "A non-null value must be provided for locations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyFinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidatePolicyFinding(")
        append("findingDetails=$findingDetails,")
        append("findingType=$findingType,")
        append("issueCode=$issueCode,")
        append("learnMoreLink=$learnMoreLink,")
        append("locations=$locations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = findingDetails.hashCode()
        result = 31 * result + (findingType.hashCode())
        result = 31 * result + (issueCode.hashCode())
        result = 31 * result + (learnMoreLink.hashCode())
        result = 31 * result + (locations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidatePolicyFinding

        if (findingDetails != other.findingDetails) return false
        if (findingType != other.findingType) return false
        if (issueCode != other.issueCode) return false
        if (learnMoreLink != other.learnMoreLink) return false
        if (locations != other.locations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyFinding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A localized message that explains the finding and provides guidance on how to address it.
         */
        public var findingDetails: kotlin.String? = null
        /**
         * The impact of the finding.
         *
         * Security warnings report when the policy allows access that we consider overly permissive.
         *
         * Errors report when a part of the policy is not functional.
         *
         * Warnings report non-security issues when a policy does not conform to policy writing best practices.
         *
         * Suggestions recommend stylistic improvements in the policy that do not impact access.
         */
        public var findingType: aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyFindingType? = null
        /**
         * The issue code provides an identifier of the issue associated with this finding.
         */
        public var issueCode: kotlin.String? = null
        /**
         * A link to additional documentation about the type of finding.
         */
        public var learnMoreLink: kotlin.String? = null
        /**
         * The list of locations in the policy document that are related to the finding. The issue code provides a summary of an issue identified by the finding.
         */
        public var locations: List<Location>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyFinding) : this() {
            this.findingDetails = x.findingDetails
            this.findingType = x.findingType
            this.issueCode = x.issueCode
            this.learnMoreLink = x.learnMoreLink
            this.locations = x.locations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.ValidatePolicyFinding = ValidatePolicyFinding(this)

        internal fun correctErrors(): Builder {
            if (findingDetails == null) findingDetails = ""
            if (findingType == null) findingType = ValidatePolicyFindingType.SdkUnknown("no value provided")
            if (issueCode == null) issueCode = ""
            if (learnMoreLink == null) learnMoreLink = ""
            if (locations == null) locations = emptyList()
            return this
        }
    }
}
