// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Updates findings with the new values provided in the request.
 */
public class UpdateFindingsRequest private constructor(builder: Builder) {
    /**
     * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) that generated the findings to update.
     */
    public val analyzerArn: kotlin.String = requireNotNull(builder.analyzerArn) { "A non-null value must be provided for analyzerArn" }
    /**
     * A client token.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The IDs of the findings to update.
     */
    public val ids: List<String>? = builder.ids
    /**
     * The ARN of the resource identified in the finding.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The state represents the action to take to update the finding Status. Use `ARCHIVE` to change an Active finding to an Archived finding. Use `ACTIVE` to change an Archived finding to an Active finding.
     */
    public val status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatusUpdate = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.UpdateFindingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFindingsRequest(")
        append("analyzerArn=$analyzerArn,")
        append("clientToken=$clientToken,")
        append("ids=$ids,")
        append("resourceArn=$resourceArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn.hashCode()
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (ids?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFindingsRequest

        if (analyzerArn != other.analyzerArn) return false
        if (clientToken != other.clientToken) return false
        if (ids != other.ids) return false
        if (resourceArn != other.resourceArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.UpdateFindingsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) that generated the findings to update.
         */
        public var analyzerArn: kotlin.String? = null
        /**
         * A client token.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The IDs of the findings to update.
         */
        public var ids: List<String>? = null
        /**
         * The ARN of the resource identified in the finding.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The state represents the action to take to update the finding Status. Use `ARCHIVE` to change an Active finding to an Archived finding. Use `ACTIVE` to change an Archived finding to an Active finding.
         */
        public var status: aws.sdk.kotlin.services.accessanalyzer.model.FindingStatusUpdate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.UpdateFindingsRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.clientToken = x.clientToken
            this.ids = x.ids
            this.resourceArn = x.resourceArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.UpdateFindingsRequest = UpdateFindingsRequest(this)

        internal fun correctErrors(): Builder {
            if (analyzerArn == null) analyzerArn = ""
            if (status == null) status = FindingStatusUpdate.SdkUnknown("no value provided")
            return this
        }
    }
}
