// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an unused access finding for a permission. IAM Access Analyzer charges for unused access analysis based on the number of IAM roles and users analyzed per month. For more details on pricing, see [IAM Access Analyzer pricing](https://aws.amazon.com/iam/access-analyzer/pricing).
 */
public class UnusedPermissionDetails private constructor(builder: Builder) {
    /**
     * A list of unused actions for which the unused access finding was generated.
     */
    public val actions: List<UnusedAction>? = builder.actions
    /**
     * The time at which the permission last accessed.
     */
    public val lastAccessed: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessed
    /**
     * The namespace of the Amazon Web Services service that contains the unused actions.
     */
    public val serviceNamespace: kotlin.String = requireNotNull(builder.serviceNamespace) { "A non-null value must be provided for serviceNamespace" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.UnusedPermissionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UnusedPermissionDetails(")
        append("actions=$actions,")
        append("lastAccessed=$lastAccessed,")
        append("serviceNamespace=$serviceNamespace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (lastAccessed?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UnusedPermissionDetails

        if (actions != other.actions) return false
        if (lastAccessed != other.lastAccessed) return false
        if (serviceNamespace != other.serviceNamespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.UnusedPermissionDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of unused actions for which the unused access finding was generated.
         */
        public var actions: List<UnusedAction>? = null
        /**
         * The time at which the permission last accessed.
         */
        public var lastAccessed: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The namespace of the Amazon Web Services service that contains the unused actions.
         */
        public var serviceNamespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.UnusedPermissionDetails) : this() {
            this.actions = x.actions
            this.lastAccessed = x.lastAccessed
            this.serviceNamespace = x.serviceNamespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.UnusedPermissionDetails = UnusedPermissionDetails(this)

        internal fun correctErrors(): Builder {
            if (serviceNamespace == null) serviceNamespace = ""
            return this
        }
    }
}
