// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an unused access finding for an action. IAM Access Analyzer charges for unused access analysis based on the number of IAM roles and users analyzed per month. For more details on pricing, see [IAM Access Analyzer pricing](https://aws.amazon.com/iam/access-analyzer/pricing).
 */
public class UnusedAction private constructor(builder: Builder) {
    /**
     * The action for which the unused access finding was generated.
     */
    public val action: kotlin.String = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The time at which the action was last accessed.
     */
    public val lastAccessed: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.UnusedAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UnusedAction(")
        append("action=$action,")
        append("lastAccessed=$lastAccessed")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (lastAccessed?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UnusedAction

        if (action != other.action) return false
        if (lastAccessed != other.lastAccessed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.UnusedAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action for which the unused access finding was generated.
         */
        public var action: kotlin.String? = null
        /**
         * The time at which the action was last accessed.
         */
        public var lastAccessed: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.UnusedAction) : this() {
            this.action = x.action
            this.lastAccessed = x.lastAccessed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.UnusedAction = UnusedAction(this)

        internal fun correctErrors(): Builder {
            if (action == null) action = ""
            return this
        }
    }
}
