// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Contains details about the CloudTrail trail being analyzed to generate a policy.
 */
public class TrailProperties private constructor(builder: Builder) {
    /**
     * Possible values are `true` or `false`. If set to `true`, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.
     */
    public val allRegions: kotlin.Boolean? = builder.allRegions
    /**
     * Specifies the ARN of the trail. The format of a trail ARN is `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`.
     */
    public val cloudTrailArn: kotlin.String = requireNotNull(builder.cloudTrailArn) { "A non-null value must be provided for cloudTrailArn" }
    /**
     * A list of regions to get CloudTrail data from and analyze to generate a policy.
     */
    public val regions: List<String>? = builder.regions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.TrailProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrailProperties(")
        append("allRegions=$allRegions,")
        append("cloudTrailArn=$cloudTrailArn,")
        append("regions=$regions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allRegions?.hashCode() ?: 0
        result = 31 * result + (cloudTrailArn.hashCode())
        result = 31 * result + (regions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrailProperties

        if (allRegions != other.allRegions) return false
        if (cloudTrailArn != other.cloudTrailArn) return false
        if (regions != other.regions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.TrailProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Possible values are `true` or `false`. If set to `true`, IAM Access Analyzer retrieves CloudTrail data from all regions to analyze and generate a policy.
         */
        public var allRegions: kotlin.Boolean? = null
        /**
         * Specifies the ARN of the trail. The format of a trail ARN is `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`.
         */
        public var cloudTrailArn: kotlin.String? = null
        /**
         * A list of regions to get CloudTrail data from and analyze to generate a policy.
         */
        public var regions: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.TrailProperties) : this() {
            this.allRegions = x.allRegions
            this.cloudTrailArn = x.cloudTrailArn
            this.regions = x.regions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.TrailProperties = TrailProperties(this)

        internal fun correctErrors(): Builder {
            if (cloudTrailArn == null) cloudTrailArn = ""
            return this
        }
    }
}
