// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Starts a scan of the policies applied to the specified resource.
 */
public class StartResourceScanRequest private constructor(builder: Builder) {
    /**
     * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) to use to scan the policies applied to the specified resource.
     */
    public val analyzerArn: kotlin.String = requireNotNull(builder.analyzerArn) { "A non-null value must be provided for analyzerArn" }
    /**
     * The ARN of the resource to scan.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning account is the account in which the resource was created.
     */
    public val resourceOwnerAccount: kotlin.String? = builder.resourceOwnerAccount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.StartResourceScanRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartResourceScanRequest(")
        append("analyzerArn=$analyzerArn,")
        append("resourceArn=$resourceArn,")
        append("resourceOwnerAccount=$resourceOwnerAccount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzerArn.hashCode()
        result = 31 * result + (resourceArn.hashCode())
        result = 31 * result + (resourceOwnerAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartResourceScanRequest

        if (analyzerArn != other.analyzerArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceOwnerAccount != other.resourceOwnerAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.StartResourceScanRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The [ARN of the analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources) to use to scan the policies applied to the specified resource.
         */
        public var analyzerArn: kotlin.String? = null
        /**
         * The ARN of the resource to scan.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The Amazon Web Services account ID that owns the resource. For most Amazon Web Services resources, the owning account is the account in which the resource was created.
         */
        public var resourceOwnerAccount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.StartResourceScanRequest) : this() {
            this.analyzerArn = x.analyzerArn
            this.resourceArn = x.resourceArn
            this.resourceOwnerAccount = x.resourceOwnerAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.StartResourceScanRequest = StartResourceScanRequest(this)

        internal fun correctErrors(): Builder {
            if (analyzerArn == null) analyzerArn = ""
            if (resourceArn == null) resourceArn = ""
            return this
        }
    }
}
