// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The proposed access control configuration for an Amazon SQS queue. You can propose a configuration for a new Amazon SQS queue or an existing Amazon SQS queue that you own by specifying the Amazon SQS policy. If the configuration is for an existing Amazon SQS queue and you do not specify the Amazon SQS policy, the access preview uses the existing Amazon SQS policy for the queue. If the access preview is for a new resource and you do not specify the policy, the access preview assumes an Amazon SQS queue without a policy. To propose deletion of an existing Amazon SQS queue policy, you can specify an empty string for the Amazon SQS policy. For more information about Amazon SQS policy limits, see [Quotas related to policies](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html).
 */
public class SqsQueueConfiguration private constructor(builder: Builder) {
    /**
     * The proposed resource policy for the Amazon SQS queue.
     */
    public val queuePolicy: kotlin.String? = builder.queuePolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.SqsQueueConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SqsQueueConfiguration(")
        append("queuePolicy=$queuePolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queuePolicy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SqsQueueConfiguration

        if (queuePolicy != other.queuePolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.SqsQueueConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The proposed resource policy for the Amazon SQS queue.
         */
        public var queuePolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.SqsQueueConfiguration) : this() {
            this.queuePolicy = x.queuePolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.SqsQueueConfiguration = SqsQueueConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
