// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The configuration for a Secrets Manager secret. For more information, see [CreateSecret](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html).
 *
 * You can propose a configuration for a new secret or an existing secret that you own by specifying the secret policy and optional KMS encryption key. If the configuration is for an existing secret and you do not specify the secret policy, the access preview uses the existing policy for the secret. If the access preview is for a new resource and you do not specify the policy, the access preview assumes a secret without a policy. To propose deletion of an existing policy, you can specify an empty string. If the proposed configuration is for a new secret and you do not specify the KMS key ID, the access preview uses the Amazon Web Services managed key `aws/secretsmanager`. If you specify an empty string for the KMS key ID, the access preview uses the Amazon Web Services managed key of the Amazon Web Services account. For more information about secret policy limits, see [Quotas for Secrets Manager.](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html).
 */
public class SecretsManagerSecretConfiguration private constructor(builder: Builder) {
    /**
     * The proposed ARN, key ID, or alias of the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The proposed resource policy defining who can access or manage the secret.
     */
    public val secretPolicy: kotlin.String? = builder.secretPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.SecretsManagerSecretConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecretsManagerSecretConfiguration(")
        append("kmsKeyId=$kmsKeyId,")
        append("secretPolicy=$secretPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (secretPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecretsManagerSecretConfiguration

        if (kmsKeyId != other.kmsKeyId) return false
        if (secretPolicy != other.secretPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.SecretsManagerSecretConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The proposed ARN, key ID, or alias of the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The proposed resource policy defining who can access or manage the secret.
         */
        public var secretPolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.SecretsManagerSecretConfiguration) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.secretPolicy = x.secretPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.SecretsManagerSecretConfiguration = SecretsManagerSecretConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
