// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * The `PublicAccessBlock` configuration to apply to this Amazon S3 bucket. If the proposed configuration is for an existing Amazon S3 bucket and the configuration is not specified, the access preview uses the existing setting. If the proposed configuration is for a new bucket and the configuration is not specified, the access preview uses `false`. If the proposed configuration is for a new access point or multi-region access point and the access point BPA configuration is not specified, the access preview uses `true`. For more information, see [PublicAccessBlockConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html).
 */
public class S3PublicAccessBlockConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
     */
    public val ignorePublicAcls: kotlin.Boolean = requireNotNull(builder.ignorePublicAcls) { "A non-null value must be provided for ignorePublicAcls" }
    /**
     * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
     */
    public val restrictPublicBuckets: kotlin.Boolean = requireNotNull(builder.restrictPublicBuckets) { "A non-null value must be provided for restrictPublicBuckets" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3PublicAccessBlockConfiguration(")
        append("ignorePublicAcls=$ignorePublicAcls,")
        append("restrictPublicBuckets=$restrictPublicBuckets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ignorePublicAcls.hashCode()
        result = 31 * result + (restrictPublicBuckets.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3PublicAccessBlockConfiguration

        if (ignorePublicAcls != other.ignorePublicAcls) return false
        if (restrictPublicBuckets != other.restrictPublicBuckets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket.
         */
        public var ignorePublicAcls: kotlin.Boolean? = null
        /**
         * Specifies whether Amazon S3 should restrict public bucket policies for this bucket.
         */
        public var restrictPublicBuckets: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration) : this() {
            this.ignorePublicAcls = x.ignorePublicAcls
            this.restrictPublicBuckets = x.restrictPublicBuckets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration = S3PublicAccessBlockConfiguration(this)

        internal fun correctErrors(): Builder {
            if (ignorePublicAcls == null) ignorePublicAcls = false
            if (restrictPublicBuckets == null) restrictPublicBuckets = false
            return this
        }
    }
}
