// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Proposed access control configuration for an Amazon S3 directory bucket. You can propose a configuration for a new Amazon S3 directory bucket or an existing Amazon S3 directory bucket that you own by specifying the Amazon S3 bucket policy. If the configuration is for an existing Amazon S3 directory bucket and you do not specify the Amazon S3 bucket policy, the access preview uses the existing policy attached to the directory bucket. If the access preview is for a new resource and you do not specify the Amazon S3 bucket policy, the access preview assumes an directory bucket without a policy. To propose deletion of an existing bucket policy, you can specify an empty string. For more information about Amazon S3 directory bucket policies, see [Example directory bucket policies for S3 Express One Zone](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html).
 */
public class S3ExpressDirectoryBucketConfiguration private constructor(builder: Builder) {
    /**
     * The proposed bucket policy for the Amazon S3 directory bucket.
     */
    public val bucketPolicy: kotlin.String? = builder.bucketPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.S3ExpressDirectoryBucketConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ExpressDirectoryBucketConfiguration(")
        append("bucketPolicy=$bucketPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketPolicy?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ExpressDirectoryBucketConfiguration

        if (bucketPolicy != other.bucketPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.S3ExpressDirectoryBucketConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The proposed bucket policy for the Amazon S3 directory bucket.
         */
        public var bucketPolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.S3ExpressDirectoryBucketConfiguration) : this() {
            this.bucketPolicy = x.bucketPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.S3ExpressDirectoryBucketConfiguration = S3ExpressDirectoryBucketConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
