// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * Proposed access control configuration for an Amazon S3 bucket. You can propose a configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket that you own by specifying the Amazon S3 bucket policy, bucket ACLs, bucket BPA settings, Amazon S3 access points, and multi-region access points attached to the bucket. If the configuration is for an existing Amazon S3 bucket and you do not specify the Amazon S3 bucket policy, the access preview uses the existing policy attached to the bucket. If the access preview is for a new resource and you do not specify the Amazon S3 bucket policy, the access preview assumes a bucket without a policy. To propose deletion of an existing bucket policy, you can specify an empty string. For more information about bucket policy limits, see [Bucket Policy Examples](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html).
 */
public class S3BucketConfiguration private constructor(builder: Builder) {
    /**
     * The configuration of Amazon S3 access points or multi-region access points for the bucket. You can propose up to 10 new access points per bucket.
     */
    public val accessPoints: Map<String, S3AccessPointConfiguration>? = builder.accessPoints
    /**
     * The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL grants per bucket. If the proposed grant configuration is for an existing bucket, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the bucket.
     */
    public val bucketAclGrants: List<S3BucketAclGrantConfiguration>? = builder.bucketAclGrants
    /**
     * The proposed bucket policy for the Amazon S3 bucket.
     */
    public val bucketPolicy: kotlin.String? = builder.bucketPolicy
    /**
     * The proposed block public access configuration for the Amazon S3 bucket.
     */
    public val bucketPublicAccessBlock: aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration? = builder.bucketPublicAccessBlock

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.S3BucketConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketConfiguration(")
        append("accessPoints=$accessPoints,")
        append("bucketAclGrants=$bucketAclGrants,")
        append("bucketPolicy=$bucketPolicy,")
        append("bucketPublicAccessBlock=$bucketPublicAccessBlock")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPoints?.hashCode() ?: 0
        result = 31 * result + (bucketAclGrants?.hashCode() ?: 0)
        result = 31 * result + (bucketPolicy?.hashCode() ?: 0)
        result = 31 * result + (bucketPublicAccessBlock?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketConfiguration

        if (accessPoints != other.accessPoints) return false
        if (bucketAclGrants != other.bucketAclGrants) return false
        if (bucketPolicy != other.bucketPolicy) return false
        if (bucketPublicAccessBlock != other.bucketPublicAccessBlock) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.S3BucketConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration of Amazon S3 access points or multi-region access points for the bucket. You can propose up to 10 new access points per bucket.
         */
        public var accessPoints: Map<String, S3AccessPointConfiguration>? = null
        /**
         * The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to 100 ACL grants per bucket. If the proposed grant configuration is for an existing bucket, the access preview uses the proposed list of grant configurations in place of the existing grants. Otherwise, the access preview uses the existing grants for the bucket.
         */
        public var bucketAclGrants: List<S3BucketAclGrantConfiguration>? = null
        /**
         * The proposed bucket policy for the Amazon S3 bucket.
         */
        public var bucketPolicy: kotlin.String? = null
        /**
         * The proposed block public access configuration for the Amazon S3 bucket.
         */
        public var bucketPublicAccessBlock: aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.S3BucketConfiguration) : this() {
            this.accessPoints = x.accessPoints
            this.bucketAclGrants = x.bucketAclGrants
            this.bucketPolicy = x.bucketPolicy
            this.bucketPublicAccessBlock = x.bucketPublicAccessBlock
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.S3BucketConfiguration = S3BucketConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration] inside the given [block]
         */
        public fun bucketPublicAccessBlock(block: aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration.Builder.() -> kotlin.Unit) {
            this.bucketPublicAccessBlock = aws.sdk.kotlin.services.accessanalyzer.model.S3PublicAccessBlockConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
