// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.accessanalyzer.model



/**
 * A proposed access control list grant configuration for an Amazon S3 bucket. For more information, see [How to Specify an ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls).
 */
public class S3BucketAclGrantConfiguration private constructor(builder: Builder) {
    /**
     * The grantee to whom you’re assigning access rights.
     */
    public val grantee: aws.sdk.kotlin.services.accessanalyzer.model.AclGrantee? = builder.grantee
    /**
     * The permissions being granted.
     */
    public val permission: aws.sdk.kotlin.services.accessanalyzer.model.AclPermission = requireNotNull(builder.permission) { "A non-null value must be provided for permission" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.accessanalyzer.model.S3BucketAclGrantConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketAclGrantConfiguration(")
        append("grantee=$grantee,")
        append("permission=$permission")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = grantee?.hashCode() ?: 0
        result = 31 * result + (permission.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketAclGrantConfiguration

        if (grantee != other.grantee) return false
        if (permission != other.permission) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.accessanalyzer.model.S3BucketAclGrantConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The grantee to whom you’re assigning access rights.
         */
        public var grantee: aws.sdk.kotlin.services.accessanalyzer.model.AclGrantee? = null
        /**
         * The permissions being granted.
         */
        public var permission: aws.sdk.kotlin.services.accessanalyzer.model.AclPermission? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.accessanalyzer.model.S3BucketAclGrantConfiguration) : this() {
            this.grantee = x.grantee
            this.permission = x.permission
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.accessanalyzer.model.S3BucketAclGrantConfiguration = S3BucketAclGrantConfiguration(this)

        internal fun correctErrors(): Builder {
            if (permission == null) permission = AclPermission.SdkUnknown("no value provided")
            return this
        }
    }
}
